/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.assignment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentToFunctionParameterJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("assignment.to.function.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/AssignmentToFunctionParameterJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.ASSIGNMENT_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/AssignmentToFunctionParameterJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("assignment.to.function.parameter.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSAssignmentExpression(JSAssignmentExpression jsAssignmentExpression) {
            super.visitJSAssignmentExpression(jsAssignmentExpression);
            JSExpression lhs = jsAssignmentExpression.getLOperand();
            this.checkOperand(lhs);
        }

        public void visitJSPrefixExpression(JSPrefixExpression jsPrefixExpression) {
            super.visitJSPrefixExpression(jsPrefixExpression);
            IElementType sign = jsPrefixExpression.getOperationSign();
            if (!JSTokenTypes.PLUSPLUS.equals(sign) && !JSTokenTypes.MINUSMINUS.equals(sign)) {
                return;
            }
            JSExpression operand = jsPrefixExpression.getExpression();
            this.checkOperand(operand);
        }

        public void visitJSPostfixExpression(JSPostfixExpression jsPostfixExpression) {
            super.visitJSPostfixExpression(jsPostfixExpression);
            IElementType sign = jsPostfixExpression.getOperationSign();
            if (!JSTokenTypes.PLUSPLUS.equals(sign) && !JSTokenTypes.MINUSMINUS.equals(sign)) {
                return;
            }
            JSExpression operand = jsPostfixExpression.getExpression();
            this.checkOperand(operand);
        }

        private void checkOperand(JSExpression operand) {
            JSExpression definiend;
            if (operand == null) {
                return;
            }
            if (operand instanceof JSDefinitionExpression && (definiend = ((JSDefinitionExpression)operand).getExpression()) instanceof JSReferenceExpression) {
                PsiElement referent = ((PsiReference)definiend).resolve();
                if (referent == null) {
                    return;
                }
                if (!(referent instanceof JSParameter)) {
                    return;
                }
                this.registerError((PsiElement)operand);
            }
            if (operand instanceof JSReferenceExpression) {
                PsiElement referent = ((PsiReference)operand).resolve();
                if (referent == null) {
                    return;
                }
                if (!(referent instanceof JSParameter)) {
                    return;
                }
                this.registerError((PsiElement)operand);
            }
        }
    }
}

