/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspection
extends LocalInspectionTool {
    private String m_shortName;

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"JavaScript", this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/BaseInspection", "getGroupPath"));
        }
        return stringArray;
    }

    @NotNull
    public String getShortName() {
        if (this.m_shortName == null) {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getSimpleName();
            this.m_shortName = InspectionProfileEntry.getShortName((String)name);
        }
        String string = this.m_shortName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/BaseInspection", "getShortName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder problemsHolder, boolean onTheFly) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/sixrr/inspectjs/BaseInspection", "buildVisitor"));
        }
        BaseInspectionVisitor visitor = this.buildVisitor();
        visitor.setProblemsHolder(problemsHolder);
        visitor.setOnTheFly(onTheFly);
        visitor.setInspection(this);
        BaseInspectionVisitor baseInspectionVisitor = visitor;
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/BaseInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    @Nullable
    protected String buildErrorString(Object ... args) {
        return null;
    }

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    @Nullable
    protected InspectionJSFix buildFix(PsiElement location) {
        return null;
    }

    @Nullable
    protected InspectionJSFix[] buildFixes(PsiElement location, boolean onTheFly) {
        return null;
    }

    public abstract BaseInspectionVisitor buildVisitor();

    protected boolean functionHasIdentifier(JSFunction function) {
        ASTNode identifier = function.findNameIdentifier();
        return identifier != null && PsiTreeUtil.isAncestor((PsiElement)function, (PsiElement)identifier.getPsi(), (boolean)true);
    }

    public PsiNamedElement getProblemElement(PsiElement psiElement) {
        return (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiFile.class});
    }
}

