/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.patterns.JSPatterns;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    @NonNls
    private static final String SUPPORT_ID = "js";

    @NotNull
    public String getId() {
        if (SUPPORT_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "getId"));
        }
        return SUPPORT_ID;
    }

    @NotNull
    public Class[] getPatternClasses() {
        Class[] classArray = new Class[]{JSPatterns.class};
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport", "getPatternClasses"));
        }
        return classArray;
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        Language language = host.getLanguage();
        return language == JavascriptLanguage.INSTANCE || language instanceof JSLanguageDialect;
    }

    public boolean useDefaultInjector(PsiLanguageInjectionHost host) {
        return true;
    }

    public String getHelpId() {
        return "reference.settings.language.injection.generic.javascript";
    }
}

