/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptExtendedConfigImpl
extends TypeScriptConfigBase {
    @NotNull
    private final TypeScriptConfigImpl mySimpleConfig;
    @NotNull
    private final TypeScriptConfig myParent;

    TypeScriptExtendedConfigImpl(@NotNull TypeScriptConfigImpl simpleConfig, @NotNull TypeScriptConfig parent) {
        if (simpleConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleConfig", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "<init>"));
        }
        this.mySimpleConfig = simpleConfig;
        this.myParent = parent;
    }

    @NotNull
    private TypeScriptConfig getConfigForOption(String name) {
        if (this.mySimpleConfig.hasOption(name)) {
            TypeScriptConfigImpl typeScriptConfigImpl = this.mySimpleConfig;
            if (typeScriptConfigImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getConfigForOption"));
            }
            return typeScriptConfigImpl;
        }
        TypeScriptConfig typeScriptConfig = this.myParent;
        if (typeScriptConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getConfigForOption"));
        }
        return typeScriptConfig;
    }

    @Override
    public boolean isDirectoryBased() {
        return this.mySimpleConfig.isDirectoryBased() && this.myParent.isDirectoryBased();
    }

    @Override
    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.mySimpleConfig.getConfigFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getConfigFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getConfigDirectory() {
        VirtualFile virtualFile = this.mySimpleConfig.getConfigDirectory();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getConfigDirectory"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public Collection<JSModulePathSubstitution> getPaths() {
        Collection<JSModulePathSubstitution> collection = this.getConfigForOption("paths").getPaths();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getPaths"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRootDirs() {
        Collection<PsiFileSystemItem> collection = this.getConfigForOption("rootDirs").getRootDirs();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getRootDirs"));
        }
        return collection;
    }

    @Override
    @NotNull
    public TypeScriptConfig.LanguageTarget getLanguageTarget() {
        TypeScriptConfig.LanguageTarget languageTarget = this.getConfigForOption("target").getLanguageTarget();
        if (languageTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getLanguageTarget"));
        }
        return languageTarget;
    }

    @Override
    @Nullable
    public VirtualFile getBaseUrl() {
        return this.getConfigForOption("baseUrl").getBaseUrl();
    }

    @Override
    @Nullable
    public String getOutDirectory() {
        return this.getConfigForOption("outDir").getOutDirectory();
    }

    @Override
    public boolean hasErrors() {
        return this.mySimpleConfig.hasErrors();
    }

    @Override
    public boolean isCompileOnSave() {
        return this.mySimpleConfig.isCompileOnSave();
    }

    @Override
    public boolean hasES6Lib() {
        return this.getConfigForOption("lib").hasES6Lib();
    }

    @Override
    public Collection<String> getLibNames() {
        return this.getConfigForOption("lib").getLibNames();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getTypeRoots() {
        Collection<VirtualFile> collection = this.getConfigForOption("typeRoots").getTypeRoots();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getTypeRoots"));
        }
        return collection;
    }

    @Override
    @NotNull
    public TypeScriptConfig.ModuleResolution getResolution() {
        TypeScriptConfig.ModuleResolution moduleResolution = this.getConfigForOption("moduleResolution").getResolution();
        if (moduleResolution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getResolution"));
        }
        return moduleResolution;
    }

    @Override
    public Collection<String> getTypes() {
        return this.getConfigForOption("types").getTypes();
    }

    @Override
    @NotNull
    public TypeScriptConfig.ModuleTarget getModule() {
        TypeScriptConfig.ModuleTarget moduleTarget = this.getConfigForOption("module").getModule();
        if (moduleTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getModule"));
        }
        return moduleTarget;
    }

    @Override
    public boolean isExcludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "isExcludedFile"));
        }
        return this.getConfigForOption("exclude").isExcludedFile(file);
    }

    @Override
    public boolean isIncludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "isIncludedFile"));
        }
        return this.getConfigForOption("include").isIncludedFile(file);
    }

    @Override
    public boolean isFromFileList(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "isFromFileList"));
        }
        return this.getConfigForOption("files").isFromFileList(file);
    }

    @Override
    public boolean isFromRootDirs(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "isFromRootDirs"));
        }
        return this.getConfigForOption("rootDirs").isFromRootDirs(file);
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDependencies() {
        ArrayList files = ContainerUtil.newArrayListWithCapacity((int)2);
        files.addAll(this.mySimpleConfig.getDependencies());
        files.addAll(this.myParent.getDependencies());
        ArrayList arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptExtendedConfigImpl", "getDependencies"));
        }
        return arrayList;
    }
}

