/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.stubs.ES6DecoratorStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6DecoratorImpl
extends JSImplicitElementProviderImpl<ES6DecoratorStub>
implements ES6Decorator {
    public ES6DecoratorImpl(ASTNode node) {
        super(node);
    }

    public ES6DecoratorImpl(ES6DecoratorStub node) {
        super(node, (IStubElementType)JSStubElementTypes.ES6_DECORATOR);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/psi/impl/ES6DecoratorImpl", "setName"));
        }
        ASTNode newNameElement = JSChangeUtil.createNameIdentifier(this.getProject(), name, JavaScriptSupportLoader.ECMA_SCRIPT_6);
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, newNameElement);
        }
        return this;
    }

    public String getName() {
        ES6DecoratorStub stub = (ES6DecoratorStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return StringUtil.replaceUnicodeEscapeSequences((String)StringUtil.unquoteString((String)node.getText()));
        }
        return null;
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        JSElementIndexingDataImpl indexingData = null;
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            indexingData = handler.processDecorator(this, indexingData);
        }
        return indexingData;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/typescript/psi/impl/ES6DecoratorImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitES6Decorator((ES6Decorator)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement getOwner() {
        PsiElement parent = this.getParent();
        if (parent instanceof JSAttributeList) {
            return parent.getParent();
        }
        return parent;
    }
}

