/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLibraryUtil;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptReferencesLibraryFix
extends FixAndIntentionAction
implements HighPriorityAction {
    public static final String LIBRARY_NAME = "ts-external-references";

    public TypeScriptReferencesLibraryFix(PsiElement comment) {
        this.registerElementRefForFix(comment, null);
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile psiFile, Editor editor) {
        if (!(psiFile instanceof JSFile)) {
            return;
        }
        JSFile file = (JSFile)psiFile;
        String libraryName = LIBRARY_NAME;
        Collection<VirtualFile> files = TypeScriptReferencesLibraryFix.getFilesForLibrary(file);
        if (files.isEmpty()) {
            return;
        }
        Collection<Module> modules = TypeScriptLibraryUtil.getModules(project, ContainerUtil.createMaybeSingletonList((Object)file.getVirtualFile()));
        TypeScriptLibraryUtil.updateLibrary(project, modules, libraryName, files, false);
    }

    @NotNull
    private static Collection<VirtualFile> getFilesForLibrary(JSFile file) {
        Collection<VirtualFile> collection = JSFixFactory.getInstance().typeScriptReferencePathValidator().getOutOfProjectReferences(file);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix", "getFilesForLibrary"));
        }
        return collection;
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile psiFile) {
        if (!(psiFile instanceof JSFile)) {
            return false;
        }
        JSFile file = (JSFile)psiFile;
        return JSFixFactory.getInstance().typeScriptReferencePathValidator().hasOutOfProjectReferences(file);
    }

    @Nls
    @NotNull
    public String getName() {
        if ("Create library with files outside the project" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix", "getName"));
        }
        return "Create library with files outside the project";
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

