/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter.blocks;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.types.TypeScriptClassElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSubBlockVisitor
extends SubBlockVisitor {
    public TypeScriptSubBlockVisitor(@Nullable JSBlock block, @NotNull CodeStyleSettings settings, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/formatter/blocks/TypeScriptSubBlockVisitor", "<init>"));
        }
        super(block, settings, JavaScriptSupportLoader.TYPESCRIPT, alignmentFactory, (JSCodeStyleSettings)settings.getCustomSettings(TypeScriptCodeStyleSettings.class));
    }

    @Override
    @Nullable
    protected Indent getIndent(ASTNode node, ASTNode child, @Nullable Indent sharedSmartIndent) {
        IElementType parentNodeElementType;
        IElementType nodeElementType = node.getElementType();
        IElementType childElementType = child.getElementType();
        ASTNode parentNode = node.getTreeParent();
        IElementType iElementType = parentNodeElementType = parentNode != null ? parentNode.getElementType() : null;
        if (parentNodeElementType instanceof TypeScriptClassElementType && JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType) && JSElementTypes.REFERENCE_EXPRESSION == childElementType) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.PROPERTY_SIGNATURE && childElementType == JSTokenTypes.IDENTIFIER) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.INDEX_SIGNATURE && childElementType == JSTokenTypes.LBRACKET) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType instanceof TypeScriptClassElementType && childElementType == TypeScriptElementTypes.INDEX_SIGNATURE) {
            return Indent.getNormalIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.IMPLICIT_MODULE && (childElementType == TypeScriptElementTypes.IMPLICIT_MODULE || childElementType == JSStubElementTypes.TYPESCRIPT_MODULE)) {
            return Indent.getNoneIndent();
        }
        return super.getIndent(node, child, sharedSmartIndent);
    }

    @Override
    protected boolean checkShouldWrapEveryItem(IElementType nodeType) {
        return super.checkShouldWrapEveryItem(nodeType) || TypeScriptSubBlockVisitor.shouldWrapEveryItem(nodeType, TypeScriptElementTypes.TYPE_PARAMETER_LIST, this.mySettings.METHOD_PARAMETERS_WRAP);
    }
}

