/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSIndentOptionsEditor;
import com.intellij.lang.javascript.formatter.JSLanguageCodeStyleSettingsProvider;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final String SPACING_CODE_SAMPLE = "module Sayings {\n    export class Greeter {\n        greeting:string;\n        constructor(message:string) {\n            this.greeting = message;\n        }\n        public greetFrom(...names:string[]) {\n            var suffix = names.reduce((s, n) -> s + \", \" + n.toUpperCase());\n            var v = x.map( s => s.length );            return \"Hello, \" + this.greeting + \" from \" + suffix;\n        }\n    }\n}\nvar g:Sayings.Greeter = new Sayings.Greeter(\"WebStorm\");\n\nimport {Component} from 'react'\nfunction foo(x,y,z) {\n    bar(1,b);\n    var i = 0;\n    var x = {0:\"zero\",1:\"one\"};\n    var a = [0,1,2];\n    var foo = function () {}\n    var v = x.map( s => s.length );    if (!i > 10) {\n        for (var j = 0; j < 10; j++) {\n            switch (j) {\n                case 0:\n                    value = \"zero\";\n                    break;\n                case 1:\n                    value = \"one\";\n                    break;\n            }\n            var c = j > 5 ? \"GT 5\" : \"LE 5\";\n        }\n    } else {\n        var j = 0;\n        try {\n            while (j < 10) {\n                if (i == j || j > 5) {\n                    a[j] = i + j * 12;\n                }\n                i = (j << 2) & 4;\n                j++;\n            }\n            do {\n                j--;\n            } while (j > 0)\n        } catch (e) {\n            alert(\"Failure: \" + e.message);\n        } finally {\n            reset(a,i);\n        }\n    }\n}";
    private static final String WRAPPING_CODE_SAMPLE = "class Foo extends Bar,\nBaz {\n}\n\nimport {Component, property1, property2, property3} from 'react'\n\nfunction buzz() { return 0; }\n\nvar foo = {\n\n    numbers:['one', 'two', 'three', 'four', 'five', 'six'],\n    data : {a:{id: 123, type: \"String\", isAvailable: true},\nb:{id: 456, type:\"Int\"}},\n// fBar : function (x,y);\n    fOne:function(a, b, c, d, e, f, g, h) {\n        var x = a + b + c + d + e + f + g + h;\n        fTwo(a, b, c, fThree(d, e, f, g, h));\n        var z = a == 'Some string' ? 'yes' : 'no';\n        z = a == 10 ? 'yes' : 'no';\n        var colors = ['red', 'green', 'blue', 'black', 'white', 'gray'];\n        for (j = 0; j < 2; j ++) i = a;        for (var i = 0; i < colors.length; i++)\n             var colorString = this.numbers[i];\n    },\n\n chainedCallSample: function(a,b,c,d,e,f) {\n        chainRoot.firstCall(a,b,c,d,e,f,g).secondCall(a,b,c,d).thirdCall(a,b,c,d).fourthCall().q(a).r(a,b).s();\n        chainRoot.x().y()\n        .z();     },\n\n    /**\n     * Function JSDoc. Long lines can be wrapped with 'Comments'/'Wrap at right margin' option\n     * @param {string} a Parameter A description.\n     * @param {string} b Parameter B description. Can extend beyond the right margin.\n     */\n    fTwo:function(a, b, c, d) {\n        foo(a, b, c, d); // Line comment which can be wrapped if long.\n        if (true)\n            return c;\n        if (a == 'one' && (b == 'two' || c == 'three')) {\n            return a + b + c + d;\n        } else return strD;\n        if (a == 'one') {\n            return 1;\n        }\n        else if(a == 'two') {\n            return 2;\n        }\n        var number = -10;\n        while (x < 0) {\n            number = number + 1;\n        }\n        do {\n            number = number + 1;\n        } while (number < 10);\n        return d;\n    },\n\n    fThree:function(strA, strB, strC, strD, strE) {\n        var number = prompt(\"Enter a number:\", 0);\n        switch (number) {\n            case 0 :\n                alert(\"Zero\");\n                break;\n            case 1:\n                alert(\"One\");\n                break;\n        }\n        try {\n            a[2]= 10;\n        }\n        catch(e) {\n            alert(\"Failure: \" + e.message);\n        }\n        return strA + strB + strC + strD + strE;\n    }\n};";

    @NotNull
    public Language getLanguage() {
        JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.TYPESCRIPT;
        if (jSLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return jSLanguageDialect;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        switch (settingsType) {
            case SPACING_SETTINGS: {
                return SPACING_CODE_SAMPLE;
            }
            case WRAPPING_AND_BRACES_SETTINGS: {
                return WRAPPING_CODE_SAMPLE;
            }
            case BLANK_LINES_SETTINGS: {
                return "var x = {\n    a:function() {\n\n\n        alert('A');\n\n    },\n\n\n\n    b:function() {\n        alert('B');\n    }\n\n}";
            }
            case INDENT_SETTINGS: {
                return "foo(\n        \"demo\",\n        {\n            title:\"Demo\",\n            width:100\n        },\n        function() {\n            object.firstCall({\n            a:'a',\n            b:'b'})\n            .secondCall();\n        }\n);";
            }
        }
        return SPACING_CODE_SAMPLE;
    }

    @Nullable
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = new CommonCodeStyleSettings(this.getLanguage());
        CommonCodeStyleSettings.IndentOptions indentOptions = commonCodeStyleSettings.initIndentOptions();
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        commonCodeStyleSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonCodeStyleSettings.LINE_COMMENT_ADD_SPACE = true;
        return commonCodeStyleSettings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new JSIndentOptionsEditor(JavaScriptSupportLoader.TYPESCRIPT);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(JSLanguageCodeStyleSettingsProvider.STANDARD_SPACING_OPTIONS);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_PROPERTY_COLON", JSBundle.message((String)"space.before.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AFTER_PROPERTY_COLON", JSBundle.message((String)"space.after.name.value.separator", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AFTER_DOTS_IN_REST_PARAMETER", JSBundle.message((String)"space.after.dots.in.rest.parameter", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_FUNCTION_LEFT_PARENTH", JSBundle.message((String)"space.before.function.left.parenth", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_TYPE_COLON", JSBundle.message((String)"space.before.type.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AFTER_TYPE_COLON", JSBundle.message((String)"space.after.type.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_CLASS_LBRACE", JSBundle.message((String)"space.before.class.interface.module.lbrace", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_BEFORE_LEFT_BRACE, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACES_WITHIN_OBJECT_LITERAL_BRACES", JSBundle.message((String)"spaces.within.object.literal.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACES_WITHIN_IMPORTS", JSBundle.message((String)"spaces.within.import.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AROUND_ARROW_FUNCTION_OPERATOR", JSBundle.message((String)"spaces.arrow.function", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            ArrayList<String> wrappingOptions = new ArrayList<String>();
            wrappingOptions.addAll(Arrays.asList(JSLanguageCodeStyleSettingsProvider.STANDARD_WRAPPING_OPTIONS));
            wrappingOptions.addAll(Arrays.asList("CLASS_BRACE_STYLE", "EXTENDS_LIST_WRAP", "ALIGN_MULTILINE_EXTENDS_LIST", "EXTENDS_KEYWORD_WRAP"));
            consumer.showStandardOptions(ArrayUtil.toStringArray(wrappingOptions));
            consumer.renameStandardOption("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.after.left.bracket", (Object[])new Object[0]));
            consumer.renameStandardOption("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", JSBundle.message((String)"js.array.new.line.before.right.bracket", (Object[])new Object[0]));
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "OBJECT_LITERAL_WRAP", "Object literals", null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "IMPORTS_WRAP", JSBundle.message((String)"js.wrap.settings.import", (Object[])new Object[0]), null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "CHAINED_CALL_DOT_ON_NEW_LINE", JSBundle.message((String)"js.chained.call.dot.on.next.line", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAPPING_CALL_CHAIN, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            ArrayList<String> blankLinesOptions = new ArrayList<String>();
            blankLinesOptions.addAll(Arrays.asList(JSLanguageCodeStyleSettingsProvider.STANDARD_BLANK_LINES_OPTIONS));
            consumer.showStandardOptions(ArrayUtil.toStringArray(blankLinesOptions));
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_AT_FIRST_COLUMN"});
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_ADD_SPACE"});
        }
    }
}

