/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import org.jetbrains.annotations.NotNull;

public class TypeScriptExternalModuleCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "fillCompletionVariants"));
        }
        PsiReference refStart = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
        PsiReference[] refs = refStart instanceof PsiMultiReference ? ((PsiMultiReference)refStart).getReferences() : new PsiReference[]{refStart};
        boolean isTypeScriptModule = false;
        for (PsiReference ref : refs) {
            PsiElement element;
            if (ref == null || !((element = ref.getElement()) instanceof ES6FromClause) && !(element.getParent() instanceof TypeScriptImportStatement)) continue;
            Object[] variants = ref.getVariants();
            if (ref instanceof JSFileReference) {
                isTypeScriptModule = true;
                TypeScriptExternalModuleCompletionContributor.processJSModuleVariants(parameters, result, ref, variants);
                continue;
            }
            if (!(ref instanceof TypeScriptNodeReference) || ref.getCanonicalText().contains("/")) continue;
            isTypeScriptModule = true;
            TypeScriptExternalModuleCompletionContributor.processTypeScriptModuleVariants(parameters, result, ref, variants);
        }
        if (isTypeScriptModule) {
            TypeScriptExternalModuleCompletionContributor.addAdditionalPathMappings(parameters, result);
            result.stopHere();
        }
    }

    private static void addAdditionalPathMappings(CompletionParameters parameters, @NotNull CompletionResultSet result) {
        TypeScriptConfig config;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "addAdditionalPathMappings"));
        }
        PsiElement position = parameters.getPosition();
        if (position.getNode().getElementType() != JSTokenTypes.STRING_LITERAL) {
            return;
        }
        String text = position.getText();
        String literalValue = StringUtil.unquoteString((String)text);
        if (literalValue.contains("\\") || literalValue.contains("/")) {
            return;
        }
        VirtualFile file = position.getContainingFile().getOriginalFile().getVirtualFile();
        if (file != null && (config = TypeScriptConfigUtil.getConfigForFile(position.getProject(), file)) != null) {
            for (JSModulePathSubstitution substitution : config.getPaths()) {
                String pattern = substitution.getPattern();
                boolean hasStar = pattern.contains("*");
                if (hasStar && !JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern)) continue;
                String variant = hasStar ? pattern.substring(0, pattern.length() - 1) : pattern;
                LookupElementBuilder newBuilder = LookupElementBuilder.create((String)variant);
                result.addElement((LookupElement)newBuilder.withIcon(AllIcons.Nodes.Folder));
            }
        }
    }

    private static void processTypeScriptModuleVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, PsiReference ref, Object[] variants) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "processTypeScriptModuleVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "processTypeScriptModuleVariants"));
        }
        for (Object variant : variants) {
            if (!(variant instanceof LookupElementBuilder)) continue;
            LookupElementBuilder newBuilder = ((LookupElementBuilder)variant).withIcon(TypeScriptFileType.INSTANCE.getIcon());
            result.addElement((LookupElement)newBuilder);
        }
    }

    private static void processJSModuleVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, PsiReference ref, Object[] variants) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "processJSModuleVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/TypeScriptExternalModuleCompletionContributor", "processJSModuleVariants"));
        }
        for (Object variant : variants) {
            if (variant instanceof LookupElement) {
                result.addElement((LookupElement)variant);
                continue;
            }
            if (!(variant instanceof PsiDirectory) || TypeScriptExternalModuleCompletionContributor.isFirstElement(ref)) continue;
            LookupElementBuilder newBuilder = LookupElementBuilder.create((Object)variant, (String)((PsiDirectory)variant).getName());
            newBuilder = newBuilder.withIcon(AllIcons.Nodes.Folder);
            result.addElement((LookupElement)newBuilder);
        }
    }

    private static boolean isFirstElement(PsiReference ref) {
        FileReferenceSet set;
        if (ref instanceof FileReference && (set = ((FileReference)ref).getFileReferenceSet()).getAllReferences().length > 0) {
            return set.getAllReferences()[0] == ref;
        }
        return true;
    }
}

