/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptCompilerVersionPanel;
import com.intellij.lang.typescript.compiler.ui.TypeScriptLanguageServicePanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigurable
implements SearchableConfigurable {
    public static final String TYPESCRIPT_CONFIG_ID = "settings.typescriptcompiler";
    private final Project myProject;
    private final TypeScriptCompilerSettings myCompilerSettings;
    private final TypeScriptSettings mySettings;
    private volatile UIHolder myUIHolder;

    private boolean isUseConfigForCompiler(boolean compilerIsEnabled) {
        return this.myCompilerSettings.isUseConfigForCompiler() || !compilerIsEnabled;
    }

    public TypeScriptConfigurable(Project project) {
        this.myProject = project;
        this.myCompilerSettings = TypeScriptCompilerSettings.getSettings(project);
        this.mySettings = TypeScriptSettings.getSettings(project);
    }

    @NotNull
    public String getId() {
        if (TYPESCRIPT_CONFIG_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable", "getId"));
        }
        return TYPESCRIPT_CONFIG_ID;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"typescript.compiler.configurable.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.typescript";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myUIHolder == null) {
            this.myUIHolder = new UIHolder();
        }
        return this.myUIHolder.myPanel;
    }

    public void apply() throws ConfigurationException {
        if (this.myUIHolder == null) {
            return;
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getService(this.myProject);
        if (this.myProject.isDefault()) {
            this.myUIHolder.apply();
            return;
        }
        service.runUnderLockAndRestart(() -> this.myUIHolder.apply());
        ApplicationManager.getApplication().invokeLater(() -> EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications(), this.myProject.getDisposed());
    }

    public void reset() {
        if (this.myUIHolder == null) {
            return;
        }
        this.myUIHolder.reset();
    }

    public void disposeUIResources() {
    }

    @Nullable
    private static String getDefaultNodeInterpreter() {
        File path = NodeDetectionUtil.findInterpreterInPath();
        return path != null ? path.getAbsolutePath() : null;
    }

    public boolean isModified() {
        if (this.myUIHolder == null) {
            return false;
        }
        return this.myUIHolder.isModified();
    }

    private final class UIHolder {
        private JCheckBox myEnableTypeScriptCompilerCheckBox;
        private JBTextField myCompilerParamsTextField;
        private NodeJsInterpreterField myNodeInterpreterTextField;
        private ScopeChooserCombo myScopeChooserCombo;
        private JPanel myCompilerComponentPanel;
        private JPanel myPanel;
        private JCheckBox myGenerateSourceMapCheckBox;
        private JCheckBox myTrackFileSystemChanges;
        private JCheckBox myHasOutDirectoryCheckbox;
        private TextFieldWithBrowseButton myOutDirectory;
        private TypeScriptCompilerVersionPanel myVersionTextPanel;
        private JCheckBox myUseMainFileCheckbox;
        private TextFieldWithBrowseButton myMainFilePath;
        private JBLabel myMainFileErrorLabel;
        private TypeScriptLanguageServicePanel myUseSerivce;
        private JBRadioButton myRadioSetManual;
        private JBRadioButton myRadioUseConfigForCompiler;
        private JPanel myCompilerOptionsPanel;

        private UIHolder() {
            FormBuilder mainFormBuilder = FormBuilder.createFormBuilder();
            this.myUseSerivce = new TypeScriptLanguageServicePanel(TypeScriptConfigurable.this.myProject);
            this.myNodeInterpreterTextField = new NodeJsInterpreterField(TypeScriptConfigurable.this.myProject, false);
            this.myNodeInterpreterTextField.setInterpreter(NodeJsInterpreterManager.getInstance(TypeScriptConfigurable.this.myProject).getDefault());
            this.myEnableTypeScriptCompilerCheckBox = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.enable", (Object[])new Object[0]));
            this.myVersionTextPanel = new TypeScriptCompilerVersionPanel(TypeScriptConfigurable.this.myProject, TypeScriptConfigurable.this.myCompilerSettings);
            mainFormBuilder.addComponent((JComponent)new TitledSeparator("Common"));
            mainFormBuilder.addLabeledComponent("&Node interpreter:", (JComponent)((Object)this.myNodeInterpreterTextField));
            mainFormBuilder.addLabeledComponent(JSBundle.message((String)"typescript.compiler.configurable.options.version", (Object[])new Object[0]), (JComponent)this.myVersionTextPanel);
            mainFormBuilder.addComponent((JComponent)this.myUseSerivce);
            mainFormBuilder.addComponent((JComponent)new TitledSeparator("Compiler"));
            mainFormBuilder.addComponent((JComponent)this.myEnableTypeScriptCompilerCheckBox);
            this.myEnableTypeScriptCompilerCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    UIHolder.this.setComponentsEnable(UIHolder.this.myEnableTypeScriptCompilerCheckBox.isSelected(), UIHolder.this.myRadioUseConfigForCompiler.isSelected());
                }
            });
            FormBuilder compilerBuilder = this.createCompilerBuilder();
            this.myRadioSetManual = new JBRadioButton("Set options manually");
            this.myRadioUseConfigForCompiler = new JBRadioButton("Use tsconfig.json");
            compilerBuilder.addComponent((JComponent)new TitledSeparator(""));
            compilerBuilder.addLabeledComponent((JComponent)this.myRadioUseConfigForCompiler, (JComponent)this.myRadioSetManual);
            ButtonGroup group = new ButtonGroup();
            group.add((AbstractButton)this.myRadioUseConfigForCompiler);
            group.add((AbstractButton)this.myRadioSetManual);
            this.myRadioUseConfigForCompiler.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    UIHolder.this.setComponentsEnable(UIHolder.this.myEnableTypeScriptCompilerCheckBox.isSelected(), UIHolder.this.myRadioUseConfigForCompiler.isSelected());
                }
            });
            FormBuilder compilerOptionsBuilder = this.createCompilerOptionsBuilder();
            this.myCompilerOptionsPanel = compilerOptionsBuilder.getPanel();
            this.myCompilerOptionsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)25));
            JPanel compilerOptionsWrapper = new JPanel(new BorderLayout());
            compilerOptionsWrapper.add((Component)this.myCompilerOptionsPanel, "North");
            compilerBuilder.addComponent((JComponent)compilerOptionsWrapper);
            this.myCompilerComponentPanel = compilerBuilder.getPanel();
            this.myCompilerComponentPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)25));
            JPanel restComponentsWrapper = new JPanel(new BorderLayout());
            restComponentsWrapper.add((Component)this.myCompilerComponentPanel, "North");
            mainFormBuilder.addComponent((JComponent)restComponentsWrapper);
            this.setComponentsEnable(this.myEnableTypeScriptCompilerCheckBox.isSelected(), this.myRadioUseConfigForCompiler.isSelected());
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)mainFormBuilder.getPanel(), "North");
            this.updateError();
        }

        @NotNull
        private FormBuilder createCompilerBuilder() {
            FormBuilder compilerBuilder = FormBuilder.createFormBuilder();
            this.myTrackFileSystemChanges = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.track.file.system", (Object[])new Object[0]));
            this.myTrackFileSystemChanges.setBorder((Border)JBUI.Borders.empty());
            compilerBuilder.addComponent((JComponent)this.myTrackFileSystemChanges);
            if (!TypeScriptConfigurable.this.myProject.isDefault()) {
                this.myScopeChooserCombo = new ScopeChooserCombo();
                compilerBuilder.addLabeledComponent(JSBundle.message((String)"typescript.compiler.configurable.options.scope", (Object[])new Object[0]), (JComponent)this.myScopeChooserCombo);
            } else {
                this.myScopeChooserCombo = null;
            }
            FormBuilder formBuilder = compilerBuilder;
            if (formBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable$UIHolder", "createCompilerBuilder"));
            }
            return formBuilder;
        }

        @NotNull
        private FormBuilder createCompilerOptionsBuilder() {
            FormBuilder compilerOptionsBuilder = FormBuilder.createFormBuilder();
            this.myCompilerParamsTextField = new JBTextField();
            compilerOptionsBuilder.addLabeledComponent(JSBundle.message((String)"typescript.compiler.configurable.options.command.line", (Object[])new Object[0]), (JComponent)this.myCompilerParamsTextField);
            this.myGenerateSourceMapCheckBox = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.generate.source.map", (Object[])new Object[0]));
            this.myGenerateSourceMapCheckBox.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)10, (int)0));
            compilerOptionsBuilder.addComponent((JComponent)this.myGenerateSourceMapCheckBox);
            this.myUseMainFileCheckbox = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.compile.main", (Object[])new Object[0]));
            this.myUseMainFileCheckbox.setBorder((Border)JBUI.Borders.empty());
            this.myMainFilePath = new TextFieldWithBrowseButton();
            this.myMainFilePath.addBrowseFolderListener("Main File", "Choose main file", TypeScriptConfigurable.this.myProject, FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)TypeScriptFileType.INSTANCE));
            this.myUseMainFileCheckbox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean enabled = UIHolder.this.myUseMainFileCheckbox.isEnabled() && UIHolder.this.myUseMainFileCheckbox.isSelected();
                    UIHolder.this.myMainFilePath.setEnabled(enabled);
                    UIHolder.this.updateError();
                }
            });
            this.myMainFileErrorLabel = new JBLabel(AllIcons.Actions.Lightning);
            compilerOptionsBuilder.addLabeledComponent((JComponent)this.myUseMainFileCheckbox, (JComponent)this.myMainFilePath);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.myMainFileErrorLabel, "West");
            this.myMainFileErrorLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myMainFileErrorLabel);
            compilerOptionsBuilder.addComponentToRightColumn((JComponent)panel);
            this.myHasOutDirectoryCheckbox = new JCheckBox(JSBundle.message((String)"typescript.compiler.configurable.options.output.path", (Object[])new Object[0]));
            this.myHasOutDirectoryCheckbox.setBorder((Border)JBUI.Borders.empty());
            this.myOutDirectory = new TextFieldWithBrowseButton();
            this.myOutDirectory.addBrowseFolderListener("Output Directory", "Choose output directory", TypeScriptConfigurable.this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
            compilerOptionsBuilder.addLabeledComponent((JComponent)this.myHasOutDirectoryCheckbox, (JComponent)this.myOutDirectory);
            this.myHasOutDirectoryCheckbox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean enabled = UIHolder.this.myHasOutDirectoryCheckbox.isEnabled() && UIHolder.this.myHasOutDirectoryCheckbox.isSelected();
                    UIHolder.this.myOutDirectory.setEnabled(enabled);
                }
            });
            FormBuilder formBuilder = compilerOptionsBuilder;
            if (formBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptConfigurable$UIHolder", "createCompilerOptionsBuilder"));
            }
            return formBuilder;
        }

        private void setComponentsEnable(boolean globalEnable, boolean useTSConfigCompiler) {
            UIUtil.setEnabled((Component)this.myCompilerComponentPanel, (boolean)globalEnable, (boolean)true);
            UIUtil.setEnabled((Component)this.myCompilerOptionsPanel, (globalEnable && !useTSConfigCompiler ? 1 : 0) != 0, (boolean)true);
            boolean enabledForOut = globalEnable && !useTSConfigCompiler && this.myHasOutDirectoryCheckbox.isSelected();
            this.myOutDirectory.setEnabled(enabledForOut);
            boolean enableForMainFile = globalEnable && !useTSConfigCompiler && this.myUseMainFileCheckbox.isSelected();
            this.myMainFilePath.setEnabled(enableForMainFile);
        }

        private void apply() {
            TypeScriptConfigurable.this.myCompilerSettings.setImmediateCompileEnabled(this.myEnableTypeScriptCompilerCheckBox.isSelected());
            TypeScriptConfigurable.this.myCompilerSettings.setTypeScriptCompilerParams(this.myCompilerParamsTextField.getText());
            TypeScriptConfigurable.this.myCompilerSettings.setNodeInterpreter(this.getNodeInterpreterValueForStore());
            TypeScriptConfigurable.this.myCompilerSettings.setGenerateSourceMap(this.myGenerateSourceMapCheckBox.isSelected());
            TypeScriptConfigurable.this.myCompilerSettings.setHasOutDirectory(this.myHasOutDirectoryCheckbox.isSelected());
            TypeScriptConfigurable.this.myCompilerSettings.setOutDirectory(this.myOutDirectory.getText());
            TypeScriptConfigurable.this.myCompilerSettings.setMainFilePath(this.myMainFilePath.getText());
            TypeScriptConfigurable.this.myCompilerSettings.setUseMainFile(this.myUseMainFileCheckbox.isSelected());
            TypeScriptConfigurable.this.myCompilerSettings.setUseConfigForCompiler(this.myRadioUseConfigForCompiler.isSelected());
            if (this.myScopeChooserCombo != null) {
                String scopeName = this.myScopeChooserCombo.getSelectedScopeName();
                TypeScriptConfigurable.this.myCompilerSettings.setScopeName(scopeName == null ? "Project Files" : scopeName);
            }
            TypeScriptConfigurable.this.myCompilerSettings.setTrackFileSystemChanges(this.myTrackFileSystemChanges.isSelected());
            this.myVersionTextPanel.apply();
            this.myUseSerivce.apply(TypeScriptConfigurable.this.myCompilerSettings);
        }

        private void reset() {
            this.myEnableTypeScriptCompilerCheckBox.setSelected(TypeScriptConfigurable.this.myCompilerSettings.isCompilerEnabled());
            this.myCompilerParamsTextField.setText(TypeScriptConfigurable.this.myCompilerSettings.getTypeScriptCompilerParams());
            this.setNodeInterpreterField(this.myNodeInterpreterTextField);
            this.myGenerateSourceMapCheckBox.setSelected(TypeScriptConfigurable.this.myCompilerSettings.isGenerateSourceMap());
            boolean compilerIsEnabled = TypeScriptConfigurable.this.myCompilerSettings.isCompilerEnabled();
            this.myEnableTypeScriptCompilerCheckBox.setSelected(compilerIsEnabled);
            this.myCompilerParamsTextField.setText(TypeScriptConfigurable.this.myCompilerSettings.getTypeScriptCompilerParams());
            this.myGenerateSourceMapCheckBox.setSelected(TypeScriptConfigurable.this.myCompilerSettings.isGenerateSourceMap());
            boolean useConfigForCompiler = TypeScriptConfigurable.this.isUseConfigForCompiler(compilerIsEnabled);
            if (useConfigForCompiler) {
                this.myRadioUseConfigForCompiler.setSelected(true);
                this.myRadioSetManual.setSelected(false);
            } else {
                this.myRadioUseConfigForCompiler.setSelected(false);
                this.myRadioSetManual.setSelected(true);
            }
            this.myMainFilePath.setText(TypeScriptConfigurable.this.myCompilerSettings.getMainFilePath());
            this.myUseMainFileCheckbox.setSelected(TypeScriptConfigurable.this.myCompilerSettings.isUseMainFile());
            boolean enableForMainFile = this.myUseMainFileCheckbox.isEnabled() && this.myUseMainFileCheckbox.isSelected();
            this.myMainFilePath.setEnabled(enableForMainFile);
            this.myHasOutDirectoryCheckbox.setSelected(TypeScriptConfigurable.this.myCompilerSettings.isHasOutDirectory());
            this.myOutDirectory.setText(TypeScriptConfigurable.this.myCompilerSettings.getOutDirectory());
            boolean enabledForOut = this.myHasOutDirectoryCheckbox.isEnabled() && this.myHasOutDirectoryCheckbox.isSelected();
            this.myOutDirectory.setEnabled(enabledForOut);
            if (this.myScopeChooserCombo != null) {
                this.myScopeChooserCombo.init(TypeScriptConfigurable.this.myProject, false, false, TypeScriptConfigurable.this.myCompilerSettings.getScopeName());
                this.myScopeChooserCombo.setUsageView(false);
                this.myScopeChooserCombo.setCurrentSelection(false);
            }
            this.myTrackFileSystemChanges.setSelected(TypeScriptConfigurable.this.myCompilerSettings.isTrackFileSystemChanges());
            this.myVersionTextPanel.resetValue();
            this.myUseSerivce.setValues(TypeScriptConfigurable.this.myCompilerSettings);
            this.updateError();
        }

        private boolean isModified() {
            this.updateError();
            if (this.myMainFileErrorLabel.isVisible()) {
                return false;
            }
            return this.myUseSerivce.isModified(TypeScriptConfigurable.this.myCompilerSettings) || this.myEnableTypeScriptCompilerCheckBox.isSelected() != TypeScriptConfigurable.this.myCompilerSettings.isCompilerEnabled() || this.myTrackFileSystemChanges.isSelected() != TypeScriptConfigurable.this.myCompilerSettings.isTrackFileSystemChanges() || this.myGenerateSourceMapCheckBox.isSelected() != TypeScriptConfigurable.this.myCompilerSettings.isGenerateSourceMap() || this.myHasOutDirectoryCheckbox.isSelected() != TypeScriptConfigurable.this.myCompilerSettings.isHasOutDirectory() || this.myRadioUseConfigForCompiler.isSelected() != TypeScriptConfigurable.this.isUseConfigForCompiler(TypeScriptConfigurable.this.myCompilerSettings.isCompilerEnabled()) || this.myHasOutDirectoryCheckbox.isSelected() && !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myOutDirectory.getText()), (CharSequence)TypeScriptConfigurable.this.myCompilerSettings.getOutDirectory()) || this.myUseMainFileCheckbox.isSelected() != TypeScriptConfigurable.this.myCompilerSettings.isUseMainFile() || this.myUseMainFileCheckbox.isSelected() && !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myMainFilePath.getText()), (CharSequence)TypeScriptConfigurable.this.myCompilerSettings.getMainFilePath()) || this.myVersionTextPanel.isModified() || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myCompilerParamsTextField.getText()), (CharSequence)TypeScriptConfigurable.this.myCompilerSettings.getTypeScriptCompilerParams()) || null != this.myScopeChooserCombo && !StringUtil.equals((CharSequence)this.myScopeChooserCombo.getSelectedScopeName(), (CharSequence)TypeScriptConfigurable.this.myCompilerSettings.getScopeName()) || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getNodeInterpreterValueForStore()), (CharSequence)TypeScriptConfigurable.this.myCompilerSettings.getNodeInterpreter());
        }

        private void setNodeInterpreterField(NodeJsInterpreterField nodeInterpreterTextField) {
            String interpreter = TypeScriptConfigurable.this.myCompilerSettings.getNodeInterpreter();
            if (interpreter != null) {
                nodeInterpreterTextField.setInterpreterRef(NodeJsInterpreterRef.create(TypeScriptConfigurable.this.myCompilerSettings.getNodeInterpreter()));
            } else {
                nodeInterpreterTextField.setInterpreter(NodeJsInterpreterManager.getInstance(TypeScriptConfigurable.this.myProject).getDefault());
            }
        }

        private String getNodeInterpreterValueForStore() {
            NodeJsInterpreter interpreter = this.myNodeInterpreterTextField.getInterpreter();
            NodeJsInterpreter defaultInterpreter = NodeJsInterpreterManager.getInstance(TypeScriptConfigurable.this.myProject).getDefault();
            if (interpreter == null) {
                return null;
            }
            if (defaultInterpreter == null) {
                return interpreter.getReferenceName();
            }
            if (interpreter == defaultInterpreter || StringUtil.equals((CharSequence)interpreter.getReferenceName(), (CharSequence)defaultInterpreter.getReferenceName())) {
                return null;
            }
            return interpreter.getReferenceName();
        }

        private void updateError() {
            this.myMainFileErrorLabel.setText("");
            this.myMainFileErrorLabel.setVisible(false);
            if (!this.myUseMainFileCheckbox.isSelected() || !this.myUseMainFileCheckbox.isEnabled()) {
                return;
            }
            String path = this.myMainFilePath.getText();
            if (StringUtil.isEmpty((String)path) || !new File(path).exists()) {
                this.myMainFileErrorLabel.setVisible(true);
                this.myMainFileErrorLabel.setText(JSBundle.message((String)"typescript.compiler.configurable.options.compile.main.error", (Object[])new Object[0]));
            }
        }
    }
}

