/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceInitialStateObject;
import com.intellij.lang.typescript.compiler.protocol.TypeScriptServiceProtocolBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServiceStandardOutputProtocol
extends TypeScriptServiceProtocolBase {
    private static final Gson GSON = new Gson();
    @NotNull
    private final Consumer<JsonObject> myInitialStateConsumer;
    @Nullable
    private OutputStream myProcessInput;
    private final AtomicInteger mySeq;
    protected final ConcurrentMap<Integer, JSLanguageServiceAnswerConsumer> myCallbacks;

    public TypeScriptServiceStandardOutputProtocol(Project project, TypeScriptCompilerSettings settings, @NotNull Consumer<JsonObject> readyConsumer) {
        if (readyConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readyConsumer", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "<init>"));
        }
        super(project, settings);
        this.mySeq = new AtomicInteger();
        this.myCallbacks = ContainerUtil.newConcurrentMap();
        this.myInitialStateConsumer = readyConsumer;
    }

    @Override
    @Nullable
    public ProcessHandler connect() throws Exception {
        GeneralCommandLine line = this.createCommandLine();
        if (line == null) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            line.withEnvironment("TSS_LOG", LOGGER.isTraceEnabled() ? "-level verbose" : "");
        }
        line.setCharset(CharsetToolkit.UTF8_CHARSET);
        OSProcessHandler processHandler = this.createProcessHandler(line);
        if (processHandler == null) {
            return null;
        }
        LOGGER.debug("Language service was started. Start initialization of typescript plugin");
        this.myProcessInput = processHandler.getProcessInput();
        try {
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)this::sendInitialState), (event, outputType, result, countDownLatch) -> {
                block8: {
                    if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
                        String text = StringUtil.trim((String)event.getText());
                        if (text.startsWith("{") && text.endsWith("}")) {
                            JsonElement answer = new JsonParser().parse(text);
                            JsonObject answerAsJsonObject = answer.getAsJsonObject();
                            try {
                                JsonPrimitive success = answerAsJsonObject.getAsJsonPrimitive("success");
                                JsonPrimitive error = answerAsJsonObject.getAsJsonPrimitive("error");
                                if (success.getAsBoolean()) {
                                    result.set((Object)true);
                                    countDownLatch.countDown();
                                    this.myInitialStateConsumer.consume((Object)answerAsJsonObject);
                                    break block8;
                                }
                                String errorText = StringUtil.notNullize((String)error.getAsString());
                                JsonPrimitive stack = answerAsJsonObject.getAsJsonPrimitive("stack");
                                LOGGER.debug("Error initialization " + errorText + "\n" + (stack == null ? "" : stack.getAsString()));
                                this.myInitializeError = errorText;
                                countDownLatch.countDown();
                            }
                            catch (Exception e) {
                                LOGGER.debug("Error initialization " + e.getMessage());
                                this.myInitializeError = "Cannot parse service initialization answer " + text + "\n";
                            }
                        } else {
                            LOGGER.warn("Expected json answer: " + event.getText());
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        LOGGER.debug("Starting language service output error: " + event.getText());
                    }
                }
            })) {
                processHandler.destroyProcess();
                return null;
            }
        }
        catch (Exception e) {
            processHandler.destroyProcess();
            throw e;
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text;
                if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)(text = event.getText())) && (text = StringUtil.trim((String)text)).startsWith("{") && text.endsWith("}")) {
                    JSLanguageServiceAnswer answer = new JSLanguageServiceAnswer(text);
                    Integer seq = answer.getSeq();
                    if (seq != null) {
                        JSLanguageServiceAnswerConsumer consumer = (JSLanguageServiceAnswerConsumer)TypeScriptServiceStandardOutputProtocol.this.myCallbacks.remove(seq);
                        if (consumer != null) {
                            TypeScriptServiceProtocolBase.LOGGER.debug("Pass request " + seq + " to consumer");
                            consumer.consume(answer);
                        } else {
                            TypeScriptServiceProtocolBase.LOGGER.debug("No callback for seq: " + text);
                        }
                    } else {
                        TypeScriptServiceProtocolBase.LOGGER.debug("No sequence number, skip request: " + text);
                    }
                }
            }
        });
        return processHandler;
    }

    @Override
    public Integer sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull String jsonData, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "sendCommand"));
        }
        if (jsonData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonData", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "sendCommand"));
        }
        int value = this.mySeq.getAndIncrement();
        if (resultConsumer != null) {
            this.myCallbacks.put(value, resultConsumer);
        }
        String request = "{ \"sessionId\":" + this.mySessionId + ", \"seq\":" + value + ", \"arguments\":" + jsonData + ", \"type\":\"" + command.getType() + "\", \"command\":\"" + command.getCommand() + "\"}\n";
        if (LOGGER.isTraceEnabled()) {
            String toPrint = request;
            if (request.length() > 1000) {
                toPrint = request.substring(0, 200) + "\n ................................(truncated)";
            }
            LOGGER.trace("Request: " + toPrint);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Request command: " + command.getCommand());
        }
        this.write(request);
        return value;
    }

    @Override
    public void cancelCommand(Object cancellationToken) {
        if (cancellationToken == null) {
            return;
        }
        this.myCallbacks.remove(cancellationToken);
    }

    private void sendInitialState() throws Exception {
        String state = this.createState();
        LOGGER.debug("Send state to service: " + state);
        this.write(state + "\n");
    }

    public String createState() {
        TypeScriptServiceInitialStateObject state = new TypeScriptServiceInitialStateObject();
        state.pluginName = "typescript";
        state.serverFolderPath = this.getServicePath();
        state.sessionId = String.valueOf(this.mySessionId);
        this.setManualOptions(state);
        return GSON.toJson((Object)state);
    }

    private void setManualOptions(@NotNull TypeScriptServiceInitialStateObject state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "setManualOptions"));
        }
        boolean bl = state.hasManualParams = !this.mySettings.isUseConfigForCompiler() && this.mySettings.isCompilerEnabled();
        if (!state.hasManualParams) {
            return;
        }
        String params = this.mySettings.getTypeScriptCompilerParams();
        Object[] parsedParams = params == null ? ArrayUtil.EMPTY_STRING_ARRAY : ParametersList.parse((String)params);
        ArrayList paramList = ContainerUtil.newArrayList((Object[])parsedParams);
        String outFile = null;
        boolean hasMainFile = this.hasMainFile();
        if (this.hasOutputDirectory()) {
            state.projectPath = this.getProjectPathString();
            Pair<String, String> pair = null;
            try {
                pair = this.getOutInformation(hasMainFile);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (pair != null) {
                outFile = (String)pair.first;
                String outDir = (String)pair.second;
                if (!StringUtil.isEmpty((String)outDir)) {
                    if (outFile == null && !outDir.contains("$")) {
                        paramList.add("--outDir");
                        paramList.add(FileUtilRt.toSystemDependentName((String)outDir));
                    } else {
                        state.outPath = (String)pair.second;
                    }
                }
            }
        }
        boolean existsCommandLineOutParam = this.checkExistsCommandLineOut((String[])parsedParams);
        if (!StringUtil.isEmpty(outFile) && !existsCommandLineOutParam) {
            paramList.add("--outFile");
            paramList.add(FileUtilRt.toSystemDependentName(outFile));
        }
        if (this.mySettings.isGenerateSourceMap()) {
            paramList.add("--sourceMap");
        }
        if (!paramList.isEmpty()) {
            state.commandLineArguments = ArrayUtil.toStringArray((Collection)paramList);
        }
        if (hasMainFile) {
            state.mainFilePath = this.mySettings.getMainFilePath();
        }
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return this.myInitializeError;
    }

    @Override
    @NotNull
    protected String getEntryPointFile() {
        if ("js-language-service.js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "getEntryPointFile"));
        }
        return "js-language-service.js";
    }

    public void dispose() {
    }

    private void write(@NotNull String data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "write"));
        }
        if (this.myProcessInput != null) {
            this.myProcessInput.write(data.getBytes(CharsetToolkit.UTF8_CHARSET));
            this.myProcessInput.flush();
        }
    }
}

