/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCodeActionInfo;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceFix
implements IntentionAction,
Comparable<IntentionAction>,
Iconable {
    @NotNull
    private final Runnable myRefreshCallback;
    private final int myIndex;
    @Nullable
    private volatile State myState;

    public TypeScriptLanguageServiceFix(@NotNull Runnable refresh, int index) {
        if (refresh == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresh", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix", "<init>"));
        }
        this.myRefreshCallback = refresh;
        this.myIndex = index;
    }

    @Nls
    @NotNull
    public String getText() {
        this.myRefreshCallback.run();
        State state = this.myState;
        String string = state == null ? "" : StringUtil.notNullize((String)state.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix", "getFamilyName"));
        }
        return string;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return JavaScriptLanguageIcons.Typescript.TypeScript_Compiler;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix", "isAvailable"));
        }
        this.myRefreshCallback.run();
        State state = this.myState;
        return state != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix", "invoke"));
        }
        State state = this.myState;
        if (state == null) {
            return;
        }
        TypeScriptCodeActionInfo fix = state.fix;
        if (fix == null) {
            return;
        }
        for (TypeScriptCodeActionInfo.FileCodeEdits change : fix.changes) {
            TypeScriptCodeActionInfo.CodeEdit[] changes;
            String name = change.fileName;
            if (StringUtil.isEmpty((String)name) || (changes = change.textChanges) == null || changes.length == 0) continue;
            String filePath = FileUtil.toSystemIndependentName((String)name);
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
            if (virtualFile == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Cannot find the file " + filePath), (String)CommonBundle.getErrorTitle(), null);
                break;
            }
            boolean okToWrite = FileModificationService.getInstance().prepareVirtualFilesForWrite(project, (Collection)ContainerUtil.createMaybeSingletonList((Object)virtualFile));
            if (!okToWrite) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Cannot write to the file " + filePath), (String)CommonBundle.getErrorTitle(), null);
                break;
            }
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document == null) continue;
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix", "lambda$invoke$0"));
                }
                int startRange = -1;
                int endRange = -1;
                PsiManager manager = file.getManager();
                PsiFile currentPsiFile = manager.findFile(virtualFile);
                for (TypeScriptCodeActionInfo.CodeEdit edit : changes) {
                    String text = StringUtil.convertLineSeparators((String)StringUtil.notNullize((String)edit.newText));
                    TextRange range = TypeScriptLanguageServiceFix.replaceText(text, document, edit);
                    if (range == null) continue;
                    TextRange newRange = new TextRange(range.getStartOffset(), range.getStartOffset() + text.length());
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    if (startRange == -1 || startRange > newRange.getStartOffset()) {
                        startRange = newRange.getStartOffset();
                    }
                    if (endRange != -1 && endRange >= newRange.getEndOffset()) continue;
                    endRange = newRange.getEndOffset();
                }
                if (startRange == -1 || startRange >= document.getTextLength()) {
                    return;
                }
                if (endRange == -1 || endRange >= document.getTextLength() || endRange < startRange) {
                    return;
                }
                if (currentPsiFile != null) {
                    CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)currentPsiFile, startRange, endRange);
                }
            }, this.getText(), null);
        }
    }

    private static TextRange replaceText(String text, Document document, TypeScriptCodeActionInfo.CodeEdit edit) {
        TypeScriptResponseCommon.Location start = edit.start;
        TypeScriptResponseCommon.Location end = edit.end;
        TypeScriptLanguageServiceUtil.PsiElementInfo info = TypeScriptLanguageServiceUtil.getPsiElementInfo(null, document, start, end);
        if (info == null) {
            return null;
        }
        TextRange range = info.getRange();
        if (range == null) {
            return null;
        }
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text);
        return range;
    }

    public void update(State state) {
        this.myState = state;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Override
    public int compareTo(IntentionAction o) {
        if (o instanceof TypeScriptLanguageServiceFix) {
            return this.myIndex - ((TypeScriptLanguageServiceFix)o).myIndex;
        }
        return 0;
    }

    public static class State {
        @Nullable
        private final TypeScriptCodeActionInfo fix;

        public State(@Nullable TypeScriptCodeActionInfo fix) {
            this.fix = fix;
        }

        @Nullable
        private String getName() {
            return this.fix == null ? null : this.fix.description;
        }
    }
}

