/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCacheImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileFileArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetMainFileErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetProjectErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateFilesCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptUpdateFilesContent;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerServiceImpl
extends TypeScriptCompilerService {
    private static final int TIME_TO_MERGE_COMPILE_EVENTS_MILLS = 2500;
    private static final int TIME_TO_MERGE_PROJECT_EVENTS_MILLS = 2500;
    public static final String BODY_FIELD = "body";
    public static final String GENERATED_FILES_FIELD = "generatedFiles";
    public static final int NO_FIX_CODE = -1;
    @NotNull
    private final MergingUpdateQueue myCompileQueue;
    @NotNull
    private final MergingUpdateQueue myProjectErrorsQueue;

    public TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        super(project, settings);
        this.myCompileQueue = new MergingUpdateQueue("TypeScript Compile queue", 2500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myProjectErrorsQueue = new MergingUpdateQueue("TypeScript Project Errors queue", 2500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    @Override
    public void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "sendCleanCommandToCompiler"));
        }
        if (!this.isServiceCreated()) {
            return;
        }
        JSLanguageService process = this.getProcess();
        if (process != null) {
            String path = command.getCompilerId();
            if (StringUtil.isEmpty((String)path)) {
                this.sendCommand(new TypeScriptReloadProjectsCommand());
            } else {
                TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
                args.projectFileName = path;
                this.sendCommand(new TypeScriptReloadProjectsCommand(args));
            }
            process.resetCaches();
        }
    }

    @Override
    @Nullable
    public Future<List<JSLanguageServiceAnnotationResult>> updateFilesAndGetErrors(@NotNull TypeScriptCompileInfoBuilder.FileHighlightingInfo info, boolean updateErrorsInReporter) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateFilesAndGetErrors"));
        }
        final JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        this.updateImpl(info.updateContext);
        final VirtualFile file = info.file;
        String path = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        if (path == null) {
            return null;
        }
        TypeScriptGetErrCommand getError = this.createGetErrCommand(path);
        Future<List<JSLanguageServiceAnnotationResult>> result = process.executeWithCache(getError, new JSLanguageServiceCacheableCommandProcessor<List<JSLanguageServiceAnnotationResult>>(){

            @Override
            public List<JSLanguageServiceAnnotationResult> process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceObject object, @NotNull JSLanguageServiceAnswer answer) {
                List results;
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                }
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                }
                JsonObject element = answer.getElement();
                JsonElement bodyProperty = element.get(TypeScriptServerServiceImpl.BODY_FIELD);
                List list = results = bodyProperty == null ? ContainerUtil.emptyList() : TypeScriptServerServiceImpl.parseAnnotationResult(bodyProperty);
                if (!TypeScriptServerServiceImpl.this.mySettings.isShowAllProjectErrors() && TypeScriptServerServiceImpl.checkState(process)) {
                    TypeScriptServerServiceImpl.this.updateErrorsForCurrentSelectedEditor(file, results);
                }
                return results;
            }

            @Override
            @NotNull
            public List<JSLanguageServiceAnnotationResult> processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull List<JSLanguageServiceAnnotationResult> result) {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "processFromCache"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "processFromCache"));
                }
                List<JSLanguageServiceAnnotationResult> list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "processFromCache"));
                }
                return list;
            }
        });
        if (this.mySettings.isShowAllProjectErrors() && !TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings)) {
            this.queueProjectErrorsTask(new TypeScriptGetProjectErrCommand(path), file);
        }
        return result;
    }

    @NotNull
    private TypeScriptGetErrCommand createGetErrCommand(@NotNull String path) {
        String mainPath;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createGetErrCommand"));
        }
        if (TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings) && !StringUtil.isEmpty((String)(mainPath = this.mySettings.getMainFilePath()))) {
            TypeScriptGetMainFileErrCommand typeScriptGetMainFileErrCommand = new TypeScriptGetMainFileErrCommand(path);
            if (typeScriptGetMainFileErrCommand == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createGetErrCommand"));
            }
            return typeScriptGetMainFileErrCommand;
        }
        TypeScriptGetErrCommand typeScriptGetErrCommand = new TypeScriptGetErrCommand(path);
        if (typeScriptGetErrCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createGetErrCommand"));
        }
        return typeScriptGetErrCommand;
    }

    @Nullable
    private static List<JSLanguageServiceAnnotationResult> parseAnnotationResult(@NotNull JsonElement bodyProperty) {
        if (bodyProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyProperty", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "parseAnnotationResult"));
        }
        TypeScriptDiagnosticsResponse result = (TypeScriptDiagnosticsResponse)JSLanguageServiceImpl.GSON.fromJson(bodyProperty, TypeScriptDiagnosticsResponse.class);
        ArrayList results = ContainerUtil.newArrayList();
        if (result == null || result.infos == null || result.infos.length == 0) {
            return ContainerUtil.emptyList();
        }
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo body : result.infos) {
            String file = body.file;
            for (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic : body.diagnostics) {
                String category = diagnostic.category;
                if (category == null) {
                    category = "error";
                }
                TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo start = diagnostic.start;
                TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo end = diagnostic.end;
                results.add(new JSLanguageServiceAnnotationResult(diagnostic.text, file, category, start == null ? 0 : start.line, start == null ? 0 : start.offset, end == null ? 0 : end.line, end == null ? 0 : end.offset));
            }
        }
        return ContainerUtil.immutableList((List)results);
    }

    private void addFileToCompileQueue(@NotNull Collection<String> fileNames) {
        if (fileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "addFileToCompileQueue"));
        }
        if (!fileNames.isEmpty()) {
            if (!TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings)) {
                fileNames.stream().filter(el -> !TypeScriptUtil.isDefinitionFile(el)).map(el -> {
                    TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                    args.file = el;
                    return args;
                }).forEach(this::queueCompileTask);
            } else {
                String path = this.mySettings.getMainFilePath();
                if (!StringUtil.isEmpty((String)path)) {
                    TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                    args.file = FileUtil.toSystemDependentName((String)path);
                    args.force = true;
                    this.queueCompileTask(args);
                }
            }
        }
    }

    private boolean isCompileEnabled() {
        return this.mySettings.isCompilerEnabledAndNeedTrackChanges();
    }

    private void queueProjectErrorsTask(final @NotNull TypeScriptGetProjectErrCommand args, final @NotNull VirtualFile file) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "queueProjectErrorsTask"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "queueProjectErrorsTask"));
        }
        this.myProjectErrorsQueue.queue(new Update(args){

            public void run() {
                TypeScriptServerServiceImpl.this.updateProjectErrors(args, file);
            }
        });
    }

    private void queueCompileTask(final @NotNull TypeScriptCompileFileArgs args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "queueCompileTask"));
        }
        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(args.file);
        if (path == null || !this.getScope().contains(path)) {
            return;
        }
        this.setMacroParamsIfNeed(args, path);
        this.myCompileQueue.queue(new Update(args){

            public void run() {
                TypeScriptServerServiceImpl.this.sendCompileCommand(args);
            }
        });
    }

    private void setMacroParamsIfNeed(@NotNull TypeScriptCompileFileArgs args, @NotNull VirtualFile path) {
        String outDir;
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "setMacroParamsIfNeed"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "setMacroParamsIfNeed"));
        }
        if (!this.mySettings.isUseConfigForCompiler() && this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)(outDir = this.mySettings.getOutDirectory())) && outDir.contains("$")) {
            Pair<String, String> info = TypeScriptCompileInfoBuilder.getModuleInfo(path, this.myProject);
            args.contentRootForMacro = (String)info.first;
            args.sourceRootForMacro = (String)info.second;
        }
    }

    private void updateProjectErrors(@NotNull TypeScriptGetProjectErrCommand command, @NotNull VirtualFile file) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateProjectErrors"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateProjectErrors"));
        }
        JSLanguageService process = this.getProcess();
        if (!TypeScriptServerServiceImpl.checkState(process)) {
            return;
        }
        process.executeNoBlocking(command, (Consumer<JSLanguageServiceAnswer>)((Consumer)answer -> {
            List<JSLanguageServiceAnnotationResult> results;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "lambda$updateProjectErrors$2"));
            }
            JsonObject element = answer.getElement();
            JsonElement bodyProperty = element.get(BODY_FIELD);
            List<JSLanguageServiceAnnotationResult> list = results = bodyProperty == null ? null : TypeScriptServerServiceImpl.parseAnnotationResult(bodyProperty);
            if (TypeScriptServerServiceImpl.checkState(process)) {
                this.updateErrorsForCurrentSelectedEditor(file, results);
            }
        }));
    }

    private void updateErrorsForCurrentSelectedEditor(@NotNull VirtualFile file, @Nullable List<JSLanguageServiceAnnotationResult> results) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateErrorsForCurrentSelectedEditor"));
        }
        Runnable runnable = () -> {
            VirtualFile editorFile;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "lambda$updateErrorsForCurrentSelectedEditor$3"));
            }
            if (!this.myProject.isOpen() || this.myProject.isDisposed() || !this.isServiceCreated()) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor instanceof EditorEx && file.equals(editorFile = ((EditorEx)editor).getVirtualFile())) {
                this.getDefaultReporter().logCurrentErrors(results == null ? ContainerUtil.emptyList() : results);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ReadAction.run(() -> runnable.run());
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, this.myProject.getDisposed());
        }
    }

    private static boolean checkState(@Nullable JSLanguageService process) {
        if (process == null) {
            return false;
        }
        JSLanguageService.State state = process.getState();
        return state != JSLanguageService.State.DISPOSED && state != JSLanguageService.State.ERROR_OR_TIMEOUT;
    }

    private void sendCompileCommand(@NotNull TypeScriptCompileFileArgs args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "sendCompileCommand"));
        }
        JSLanguageService process = this.getProcess();
        if (!TypeScriptServerServiceImpl.checkState(process)) {
            return;
        }
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        Consumer consumer = answer -> {
            JsonObject element = answer.getElement();
            JsonElement jsonElement = element.get(BODY_FIELD);
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return;
            }
            TypeScriptCompilerConfigUtil.processEmitFilesAfterCompiling(this.myProject, jsonElement.getAsJsonObject(), GENERATED_FILES_FIELD);
        };
        process.executeNoBlocking(command, (Consumer<JSLanguageServiceAnswer>)consumer);
    }

    @Override
    @Nullable
    protected JSLanguageService createLanguageService() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myInitialization.getValue();
        String interpreter = TypeScriptLanguageServiceUtil.getNodeInterpreterPath(this.myProject);
        boolean hasInterpreter = !StringUtil.isEmptyOrSpaces((String)interpreter);
        ThreeState prevValue = this.myHasInterpreter;
        this.myHasInterpreter = ThreeState.fromBoolean((boolean)hasInterpreter);
        if (!hasInterpreter) {
            this.showInterpreterError(prevValue);
            return null;
        }
        Ref serviceRef = Ref.create();
        Condition expiredCondition = el -> {
            JSLanguageService service = (JSLanguageService)serviceRef.get();
            if (service == null) {
                return false;
            }
            return service.getState() == JSLanguageService.State.DISPOSED;
        };
        Consumer readyConsumer = el -> {
            if (this.myToolWindowManager != null) {
                try {
                    JsonObject message = el.getAsJsonObject("message");
                    if (message != null) {
                        JsonPrimitive version = message.getAsJsonPrimitive("version");
                        String versionAsString = TypeScriptLanguageServiceUtil.getNormalizedVersionString(version.getAsString());
                        ApplicationManager.getApplication().invokeLater(() -> this.myToolWindowManager.setName(versionAsString), expiredCondition);
                        JsonElement codes = message.get("supportedErrorCodes");
                        if (codes != null && codes.isJsonArray()) {
                            JsonArray array = codes.getAsJsonArray();
                            int[] result = new int[array.size()];
                            int i = 0;
                            for (JsonElement element : array) {
                                if (element.isJsonPrimitive()) {
                                    JsonPrimitive primitive = element.getAsJsonPrimitive();
                                    try {
                                        if (primitive.isNumber()) {
                                            result[i++] = primitive.getAsInt();
                                            continue;
                                        }
                                        if (!primitive.isString()) continue;
                                        result[i++] = Integer.valueOf(primitive.getAsString());
                                    }
                                    catch (Exception e) {
                                        result[i++] = -1;
                                    }
                                    continue;
                                }
                                result[i++] = -1;
                            }
                            this.myErrorCodeFixes = result;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        TypeScriptServiceStandardOutputProtocol protocol = new TypeScriptServiceStandardOutputProtocol(this.myProject, this.mySettings, (Consumer<JsonObject>)readyConsumer);
        boolean setActive = this.myFailCount.get() == 0L;
        JSLanguageService.ServiceInfoReporter errorReporter = this.myToolWindowManager != null ? new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.myToolWindowManager, setActive) : this.myDefaultReporter;
        JSLanguageServiceImpl service = new JSLanguageServiceImpl(this.myProject, protocol, this.myToolWindowManager, errorReporter, new TypeScriptLanguageServiceCacheImpl(this.myProject));
        serviceRef.set((Object)service);
        Consumer<JSLanguageService> initializer = this.getInitializedCallback();
        initializer.consume((Object)service);
        return service;
    }

    private void showInterpreterError(@NotNull ThreeState prevValue) {
        if (prevValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevValue", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "showInterpreterError"));
        }
        if (prevValue != this.myHasInterpreter) {
            Runnable runnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myToolWindowManager != null) {
                    this.myToolWindowManager.logCurrentErrors((List<JSLanguageServiceAnnotationResult>)JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"typescript.service.node.error", (Object[])new Object[0])), this.mySettings.isCompilerEnabled());
                }
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }, this.myProject.getDisposed());
            if (this.myProject.isOpen()) {
                StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
            }
        }
    }

    @Override
    public void addFileToCompileQueue(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "addFileToCompileQueue"));
        }
        if (!this.isCompileEnabled()) {
            return;
        }
        GlobalSearchScope scope = this.getScope();
        List fileNames = ContainerUtil.mapNotNull(files, el -> {
            if (el.isInLocalFileSystem() && el.isValid() && scope.accept(el) && null == el.getUserData(JSLanguageService.GENERATED_FILE_MARKER)) {
                return TypeScriptCompilerConfigUtil.normalizeNameAndPath(el);
            }
            return null;
        });
        this.addFileToCompileQueue(fileNames);
    }

    @Override
    @Nullable
    public Future<Boolean> update(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "update"));
        }
        return this.updateImpl(context);
    }

    @Nullable
    private Future<Boolean> updateImpl(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateImpl"));
        }
        TypeScriptLanguageServiceUpdateFilesCommand command = new TypeScriptLanguageServiceUpdateFilesCommand(context.timestamps, context.contents);
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        return process.execute(command, new JSLanguageServiceCommandResultProcessor<Boolean>(){

            @Override
            @NotNull
            public Boolean process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$4", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$4", "process"));
                }
                if (serviceObject instanceof TypeScriptUpdateFilesContent && TypeScriptServerServiceImpl.this.isCompileEnabled()) {
                    TypeScriptServerServiceImpl.this.addFileToCompileQueue(((TypeScriptUpdateFilesContent)serviceObject).files.keySet());
                }
                Boolean bl = true;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$4", "process"));
                }
                return bl;
            }
        });
    }

    @NotNull
    protected Consumer<JSLanguageService> getInitializedCallback() {
        Consumer consumer = service -> ReadAction.run(() -> {
            TypeScriptLanguageServiceEvents events = TypeScriptLanguageServiceEvents.getService(this.myProject);
            ArrayList toProcess = ContainerUtil.newArrayList();
            VirtualFile mainFile = TypeScriptLanguageServiceUtil.getMainFile(this.mySettings);
            if (mainFile != null) {
                toProcess.add(mainFile);
            }
            toProcess.addAll(TypeScriptLanguageServiceUtil.getOpenedFiles(this.myProject).keySet());
            for (final VirtualFile vFile : toProcess) {
                service.execute(events.createOpenEditorCommand(vFile), new JSLanguageServiceCommandResultProcessor<Object>(){

                    @Override
                    public Object process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                        if (serviceObject == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$5", "process"));
                        }
                        if (answer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$5", "process"));
                        }
                        service.resetCaches();
                        ReadAction.run(() -> {
                            PsiFile file;
                            if (service.getState() == JSLanguageService.State.DISPOSED) {
                                return;
                            }
                            if (vFile.isValid() && !TypeScriptServerServiceImpl.this.myProject.isDisposed() && (file = PsiManager.getInstance((Project)TypeScriptServerServiceImpl.this.myProject).findFile(vFile)) != null) {
                                DaemonCodeAnalyzer.getInstance((Project)TypeScriptServerServiceImpl.this.myProject).restart(file);
                            }
                        });
                        return null;
                    }
                });
            }
        });
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getInitializedCallback"));
        }
        return consumer;
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "compileFileAndGetErrors"));
        }
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        String path = file.getCanonicalPath();
        if (path == null || TypeScriptUtil.isDefinitionFile(path)) {
            return null;
        }
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        this.setMacroParamsIfNeed(args, file);
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        return process.execute(command, this.createCompileResultProcessor());
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "compileConfigProjectAndGetErrors"));
        }
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.projectFileName = TypeScriptCompilerConfigUtil.normalizeNameAndPath(config.getConfigFile());
        return process.execute(new TypeScriptCompileCommand(args), this.createCompileResultProcessor());
    }

    @NotNull
    private JSLanguageServiceCommandResultProcessor<JSLanguageServiceResultContainer> createCompileResultProcessor() {
        JSLanguageServiceCommandResultProcessor<JSLanguageServiceResultContainer> jSLanguageServiceCommandResultProcessor = new JSLanguageServiceCommandResultProcessor<JSLanguageServiceResultContainer>(){

            @Override
            public JSLanguageServiceResultContainer process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$6", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$6", "process"));
                }
                JsonObject element = answer.getElement();
                JsonElement body = element.get(TypeScriptServerServiceImpl.BODY_FIELD);
                if (body == null || !body.isJsonObject()) {
                    return null;
                }
                JsonObject bodyObject = body.getAsJsonObject();
                TypeScriptCompilerConfigUtil.processEmitFilesAfterCompiling(TypeScriptServerServiceImpl.this.myProject, bodyObject, TypeScriptServerServiceImpl.GENERATED_FILES_FIELD);
                List annotationResults = TypeScriptServerServiceImpl.parseAnnotationResult((JsonElement)bodyObject);
                return new JSLanguageServiceResultContainer(annotationResults == null ? ContainerUtil.emptyList() : annotationResults, ContainerUtil.emptyList());
            }
        };
        if (jSLanguageServiceCommandResultProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompileResultProcessor"));
        }
        return jSLanguageServiceCommandResultProcessor;
    }

    public void flushQueues() {
        this.myCompileQueue.flush();
        this.myProjectErrorsQueue.flush();
    }

    @Override
    public JSLanguageService getLSProcess() {
        return super.getLSProcess();
    }
}

