/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceUtil {
    public static final String TYPESCRIPT_MODULE_NAME = "typescript";
    public static final String LIB_DIRECTORY = "lib";
    public static final long QUOTA_MILLS = 15L;
    public static final long TIMEOUT_MILLS = TimeUnit.SECONDS.toMillis(20L);
    public static volatile boolean USE_SERVICE = false;

    public static void setUseService(boolean useService) {
        USE_SERVICE = useService;
    }

    public static boolean isServiceEnabled(Project project) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return TypeScriptLanguageServiceUtil.isServiceEnabled(settings);
    }

    public static boolean isServiceEnabled(@Nullable TypeScriptCompilerSettings settings) {
        if (settings == null || ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return false;
        }
        return settings.isUseService() || settings.isCompilerEnabledAndNeedTrackChanges();
    }

    public static boolean isServiceAnnotationAcceptable(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "isServiceAnnotationAcceptable"));
        }
        return TypeScriptLanguageServiceUtil.isServiceEnabled(project) && !project.isDisposed() && !TypeScriptLanguageServiceUtil.shouldSkipProcessing(project, file);
    }

    public static boolean useServiceCompletion(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "useServiceCompletion"));
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && TypeScriptLanguageServiceUtil.isFileCorrect(file) && TypeScriptCompilerSettings.getSettings(project).isUseServiceCompletion();
    }

    public static boolean useServiceParameterInfo(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "useServiceParameterInfo"));
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && TypeScriptLanguageServiceUtil.isFileCorrect(file) && TypeScriptCompilerSettings.getSettings(project).isUseServiceParameterInfo();
    }

    public static boolean useNewTypeScriptService(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return false;
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return settings.isUseService();
    }

    public static boolean shouldSkipProcessing(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "shouldSkipProcessing"));
        }
        return !TypeScriptLanguageServiceUtil.isFileCorrect(file) || !TypeScriptCompilerSettings.acceptFileType(file.getFileType());
    }

    public static boolean isFileCorrect(VirtualFile file) {
        return file != null && file.isInLocalFileSystem() && file.isValid() && null == file.getUserData(JSLanguageService.GENERATED_FILE_MARKER);
    }

    @NotNull
    public static Map<VirtualFile, Document> getOpenedFiles(Project project) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap filesToOpen = ContainerUtil.newHashMap();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project editorProject = editor.getProject();
            if (editorProject == null || editorProject != project || !(editor instanceof EditorEx) || editor.getProject() != editorProject || (vFile = ((EditorEx)editor).getVirtualFile()) == null || TypeScriptLanguageServiceUtil.shouldSkipProcessing(editorProject, vFile)) continue;
            filesToOpen.put(vFile, editor.getDocument());
        }
        HashMap hashMap = filesToOpen;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "getOpenedFiles"));
        }
        return hashMap;
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator) {
        if (future == null) {
            return null;
        }
        try {
            if (future.isDone()) {
                return future.get();
            }
            for (long totalWait = timeoutMills; totalWait > 0L; totalWait -= quotaMills) {
                try {
                    return future.get(quotaMills, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    if (indicator == null) {
                        ProgressManager.checkCanceled();
                        continue;
                    }
                    indicator.checkCanceled();
                    continue;
                }
            }
            if (future.isDone()) {
                return future.get();
            }
            future.cancel(false);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static VirtualFile getMainFile(TypeScriptCompilerSettings settings) {
        if (TypeScriptLanguageServiceUtil.shouldUseMainFile(settings)) {
            String path = settings.getMainFilePath();
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    public static boolean shouldUseMainFile(TypeScriptCompilerSettings settings) {
        return !settings.isUseConfigForCompiler() && settings.isCompilerEnabled() && settings.isUseMainFile();
    }

    @Nullable
    public static VirtualFile findTypeScriptLibDirectory(@Nullable Project project) {
        VirtualFile node_modules;
        VirtualFile lib;
        VirtualFile root;
        if (project == null || project.isDefault() || project.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        Object[] stopDirs = ProjectRootManager.getInstance((Project)project).getContentRoots();
        if (stopDirs.length == 1 && (root = (VirtualFile)ArrayUtil.getFirstElement((Object[])stopDirs)) != null && (lib = TypeScriptLanguageServiceUtil.getTypeScriptLibFromNodeModules(node_modules = root.findChild("node_modules"))) != null) {
            return lib;
        }
        return (VirtualFile)ReadAction.compute(() -> {
            Collection<TypeScriptConfig> files = TypeScriptConfigService.Provider.getConfigFiles(project);
            if (files.isEmpty()) {
                return null;
            }
            ArrayList result = ContainerUtil.newArrayList();
            for (TypeScriptConfig file : files) {
                VirtualFile directory = file.getConfigDirectory();
                VirtualFile configNodeModules = directory.findChild("node_modules");
                result.add(TypeScriptLanguageServiceUtil.getTypeScriptLibFromNodeModules(configNodeModules));
            }
            if (result.size() == 1) {
                return (VirtualFile)ContainerUtil.getFirstItem((List)result);
            }
            return null;
        });
    }

    public static VirtualFile getTypeScriptLibFromNodeModules(@Nullable VirtualFile nodeModules) {
        if (nodeModules == null) {
            return null;
        }
        VirtualFile typescript = nodeModules.findChild(TYPESCRIPT_MODULE_NAME);
        if (typescript == null) {
            return null;
        }
        VirtualFile lib = typescript.findChild(LIB_DIRECTORY);
        if (lib == null) {
            return null;
        }
        VirtualFile[] children = lib.getChildren();
        if (children != null) {
            for (VirtualFile file : children) {
                if (!ArrayUtil.contains((String)file.getName(), (String[])TypeScriptCompilerSettings.TYPESCRIPT_SERVICE_FILES)) continue;
                return lib;
            }
        }
        return null;
    }

    @Nullable
    public static String getNormalizedVersionString(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Version parseVersion = Version.parseVersion((String)version);
        if (parseVersion == null) {
            return null;
        }
        return parseVersion.toString();
    }

    public static void fillFilePosition(@NotNull TypeScriptFileLocationRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull Document document, int positionInFileOffset) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "fillFilePosition"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "fillFilePosition"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "fillFilePosition"));
        }
        int line = document.getLineNumber(positionInFileOffset);
        int offset = positionInFileOffset - document.getLineStartOffset(line);
        args.line = line + 1;
        args.offset = offset + 1;
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(virtualFile);
    }

    @Nullable
    public static String getNodeInterpreterPath(Project project) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        String interpreter = settings.getNodeInterpreter();
        if (interpreter == null) {
            return TypeScriptLanguageServiceUtil.getPathIfValid(NodeJsInterpreterManager.getInstance(project).getDefault());
        }
        NodeJsInterpreterRef refName = NodeJsInterpreterRef.create(interpreter);
        return TypeScriptLanguageServiceUtil.getPathIfValid(refName.resolve(project));
    }

    private static String getPathIfValid(@Nullable NodeJsInterpreter interpreter) {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter != null && localInterpreter.isValid()) {
            return localInterpreter.getInterpreterSystemDependentPath();
        }
        return null;
    }

    @Contract(value="!null,_->!null")
    public static String getRelativePath(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "getRelativePath"));
        }
        if (StringUtil.isEmpty((String)path)) {
            return path;
        }
        return (String)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "lambda$getRelativePath$1"));
            }
            VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
            if (fileByPath == null) {
                return path;
            }
            if (DumbService.isDumb((Project)project) || project.isDisposed() || !project.isOpen()) {
                return path;
            }
            VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(fileByPath);
            if (root != null) {
                return "/" + VfsUtilCore.getRelativePath((VirtualFile)fileByPath, (VirtualFile)root);
            }
            return path;
        });
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document, int line, int column, int endLine, int endColumn) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "getElementInfo"));
        }
        try {
            int lineStartOffset;
            if (line < 0 || line >= document.getLineCount()) {
                return null;
            }
            int errorStartOffset = lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if ((errorStartOffset += column) > lineEndOffset) {
                return null;
            }
            PsiElement element = null;
            TextRange range = null;
            if (endLine < 0 && file != null) {
                element = file.findElementAt(errorStartOffset);
                if (element == null && lineStartOffset < errorStartOffset) {
                    element = file.findElementAt(errorStartOffset - 1);
                }
            } else {
                if (endLine < 0 || endLine >= document.getLineCount()) {
                    return null;
                }
                int errorEndOffset = document.getLineStartOffset(endLine);
                int lineToEndOffset = document.getLineEndOffset(endLine);
                if ((errorEndOffset += endColumn) > lineToEndOffset) {
                    return null;
                }
                range = TextRange.create((int)errorStartOffset, (int)errorEndOffset);
            }
            return new PsiElementInfo(element, range);
        }
        catch (Exception e) {
            JSLanguageServiceImpl.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static PsiElementInfo getPsiElementInfo(@Nullable PsiFile file, @NotNull Document document, @Nullable TypeScriptResponseCommon.Location start, @Nullable TypeScriptResponseCommon.Location end) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "getPsiElementInfo"));
        }
        if (start == null || end == null) {
            return null;
        }
        int line = start.line - 1;
        int startOffset = start.offset - 1;
        int endLine = end.line - 1;
        int endOffset = end.offset - 1;
        return TypeScriptLanguageServiceUtil.getElementInfo(file, document, line, startOffset, endLine, endOffset);
    }

    public static class PsiElementInfo {
        @Nullable
        private final PsiElement myElement;
        @Nullable
        private final TextRange myRange;

        public PsiElementInfo(@Nullable PsiElement element, @Nullable TextRange range) {
            this.myElement = element;
            this.myRange = range;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        @Nullable
        public TextRange getRange() {
            return this.myRange;
        }
    }
}

