/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileCurrentAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptToolWindowProvider {
    private final JSLanguageServiceToolWindowManager myToolWindow;
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        if (project == null || project.isDefault() || project.isDisposed()) {
            return null;
        }
        TypeScriptToolWindowProvider provider = (TypeScriptToolWindowProvider)ServiceManager.getService((Project)project, TypeScriptToolWindowProvider.class);
        return provider == null ? null : provider.getToolWindow();
    }

    public TypeScriptToolWindowProvider(final Project project, TypeScriptCompilerSettings settings) {
        AnAction restartCompilerAction = new AnAction(JSBundle.message((String)"typescript.service.action.restart", (Object[])new Object[0]), JSBundle.message((String)"typescript.service.action.restart", (Object[])new Object[0]), AllIcons.Javaee.UpdateRunningApplication){

            public void actionPerformed(AnActionEvent e) {
                TypeScriptCompilerService service = TypeScriptCompilerService.getService(project);
                if (service != null) {
                    service.restartService(false);
                }
            }
        };
        TypeScriptCompileCurrentAction typeScriptCompileCurrentAction = new TypeScriptCompileCurrentAction(){

            @Override
            protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
                return FileEditorManager.getInstance((Project)project).getSelectedFiles();
            }

            @Override
            protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager, @NotNull Collection<JSLanguageServiceAnnotationResult> infos) {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/typescript/compiler/TypeScriptToolWindowProvider$2", "logErrors"));
                }
                if (infos == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/compiler/TypeScriptToolWindowProvider$2", "logErrors"));
                }
                manager.logCurrentErrors((List<JSLanguageServiceAnnotationResult>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), true);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/compiler/TypeScriptToolWindowProvider$2", "update"));
                }
                e.getPresentation().setEnabledAndVisible(true);
            }
        };
        this.myToolWindow = new TypeScriptLanguageServiceToolWindowManager(project, typeScriptCompileCurrentAction, restartCompilerAction, settings);
        Disposer.register((Disposable)project, (Disposable)this.myToolWindow);
    }

    public JSLanguageServiceToolWindowManager getToolWindow() {
        return this.myToolWindow;
    }
}

