/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.watcher;

import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptClosureCompressorTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/watcher/JavaScriptClosureCompressorTaskConsumer", "isAvailable"));
        }
        return false;
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName("Closure Compiler");
        options.setDescription("Compiles .js files");
        options.setFileExtension(JavaScriptFileType.INSTANCE.getDefaultExtension());
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        String nameWithoutExtensionMacro = new FileNameWithoutExtension().getName();
        options.setArguments("--compilation_level SIMPLE_OPTIMIZATIONS --js $" + new FileNameMacro().getName() + "$");
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        options.setOutputFromStdout(true);
        options.setOutput("$" + nameWithoutExtensionMacro + "$.min.js");
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/watcher/JavaScriptClosureCompressorTaskConsumer", "getOptionsTemplate"));
        }
        return taskOptions;
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/watcher/JavaScriptClosureCompressorTaskConsumer", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/watcher/JavaScriptClosureCompressorTaskConsumer", "additionalConfiguration"));
        }
        super.additionalConfiguration(project, file, options);
        options.setProgram(JavaScriptClosureCompressorTaskConsumer.findExecutableInPath((String)"closure-compiler"));
    }
}

