/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInsertModifierFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(JSInsertModifierFix.class);
    private JSAttributeList.ModifierType myModifier;

    public JSInsertModifierFix(JSAttributeListOwner element, JSAttributeList.ModifierType modifier) {
        super((PsiElement)element);
        this.myModifier = modifier;
    }

    public static String getSetModifierText(@NotNull JSAttributeListOwner myClassOrMethod, @NotNull String modifierOrVisibility) {
        if (myClassOrMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myClassOrMethod", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "getSetModifierText"));
        }
        if (modifierOrVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierOrVisibility", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "getSetModifierText"));
        }
        String type = myClassOrMethod instanceof JSClass ? JSBundle.message((String)(((JSClass)myClassOrMethod).isInterface() ? "interface.description" : "class.description"), (Object[])new Object[]{myClassOrMethod.getName()}) : (myClassOrMethod instanceof JSFunction ? (((JSFunction)myClassOrMethod).isConstructor() ? JSBundle.message((String)"constructor.description", (Object[])new Object[]{myClassOrMethod.getName()}) : (((JSFunction)myClassOrMethod).isGetProperty() ? JSBundle.message((String)"getter.description", (Object[])new Object[]{myClassOrMethod.getName()}) : (((JSFunction)myClassOrMethod).isSetProperty() ? JSBundle.message((String)"setter.description", (Object[])new Object[]{myClassOrMethod.getName()}) : JSBundle.message((String)"method.description", (Object[])new Object[]{myClassOrMethod.getName()})))) : (myClassOrMethod instanceof JSVariable ? JSBundle.message((String)(((JSVariable)myClassOrMethod).isConst() ? "constant.description" : "field.description"), (Object[])new Object[]{myClassOrMethod.getName()}) : ""));
        return JSBundle.message((String)"javascript.fix.set.element.visibility", (Object[])new Object[]{type, modifierOrVisibility});
    }

    @Nls
    @NotNull
    public String getText() {
        JSAttributeListOwner myClassOrMethod = (JSAttributeListOwner)this.getStartElement();
        if (myClassOrMethod == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "getText"));
            }
            return "";
        }
        String string = JSInsertModifierFix.getSetModifierText(myClassOrMethod, this.getModifier().keyword);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "getText"));
        }
        return string;
    }

    private JSAttributeList.ModifierType getModifier() {
        return this.myModifier;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "invoke"));
        }
        if (!(endElement instanceof JSAttributeListOwner)) {
            return;
        }
        JSAttributeListOwner owner = (JSAttributeListOwner)endElement;
        JSAttributeList list = owner.getAttributeList();
        if (list == null) {
            LOG.error("Attibute list must exist");
            return;
        }
        Pair<PsiElement, Boolean> toInsert = this.getAnchorToInsert(list);
        PsiElement newModifier = this.createModifier(list);
        if (((Boolean)toInsert.second).booleanValue() && toInsert.first != null) {
            JSChangeUtil.doDoAddAfter((PsiElement)list, newModifier, (PsiElement)toInsert.first);
        } else {
            JSChangeUtil.doDoAddBefore((PsiElement)list, newModifier, (PsiElement)toInsert.first);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat(list.getParent());
    }

    @NotNull
    private PsiElement createModifier(JSAttributeList list) {
        ASTNode newAttributeListNode = JSChangeUtil.createJSTreeFromText(list.getProject(), this.getModifier().keyword, DialectDetector.getLanguageDialect((PsiElement)list));
        assert (newAttributeListNode != null);
        PsiElement attributeList = newAttributeListNode.getPsi();
        JSAttributeList newAttributeList = (JSAttributeList)attributeList;
        PsiElement result = newAttributeList.findModifierElement(this.getModifier());
        assert (result != null);
        PsiElement psiElement = result;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "createModifier"));
        }
        return psiElement;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public Pair<PsiElement, Boolean> getAnchorToInsert(@NotNull JSAttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/validation/fixes/JSInsertModifierFix", "getAnchorToInsert"));
        }
        JSAttributeList.ModifierType currentModifier = this.getModifier();
        PsiElement anchor = list.getLastChild();
        boolean afterCurrent = false;
        for (JSAttributeList.ModifierType modifier : JSAttributeListWrapper.MODIFIERS) {
            if (modifier == currentModifier) {
                afterCurrent = true;
                continue;
            }
            PsiElement possibleElement = list.findModifierElement(modifier);
            if (possibleElement == null) continue;
            anchor = possibleElement;
            if (afterCurrent) break;
        }
        return Pair.create((Object)anchor, (Object)afterCurrent);
    }
}

