/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ImplementJSDocMethodsFix
implements LocalQuickFix {
    final JSSourceElement myAnchor;
    final String myClassName;
    final Set<String> myNonimplemented;

    public ImplementJSDocMethodsFix(@NotNull JSSourceElement anchor, @NotNull String className, Set<String> nonimplemented) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix", "<init>"));
        }
        this.myAnchor = anchor;
        this.myClassName = className;
        this.myNonimplemented = nonimplemented;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.fix.implement.methods", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix", "applyFix"));
        }
        for (String methodName : this.myNonimplemented) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.myClassName);
            builder.append(".prototype.");
            builder.append(methodName);
            builder.append(" = function(){};");
            PsiElement methodImplementation = JSChangeUtil.createJSTreeFromText(project, builder.toString()).getPsi();
            this.myAnchor.getParent().addAfter(methodImplementation, (PsiElement)this.myAnchor);
        }
    }
}

