/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSSemanticKeywordHighlighter
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final AnnotationHolderImpl myHolder;
    private final JSKeywordHighlighterVisitor myVisitor;

    public JSSemanticKeywordHighlighter(@NotNull PsiFile file, Document document) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/JSSemanticKeywordHighlighter", "<init>"));
        }
        super(file.getProject(), document);
        this.myFile = file;
        this.myHolder = new AnnotationHolderImpl(new AnnotationSession(file));
        JSAnalysisHandlersFactory factory = JSAnalysisHandlersFactory.forElement((PsiElement)file);
        this.myVisitor = factory.createKeywordHighlighterVisitor((AnnotationHolder)this.myHolder);
    }

    protected JSHighlighter getHighlighter(PsiFile file) {
        Language dialect = DialectDetector.languageOfElement((PsiElement)file);
        return dialect instanceof JSLanguageDialect ? (JSHighlighter)SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null) : new JSHighlighter(JavascriptLanguage.DIALECT_OPTION_HOLDER);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/javascript/validation/JSSemanticKeywordHighlighter", "doCollectInformation"));
        }
        this.myHolder.clear();
        if (this.myFile instanceof JSFile) {
            this.myFile.acceptChildren((PsiElementVisitor)this.myVisitor);
        } else {
            JSIndexContent.acceptChildren(this.myFile, (PsiElementVisitor)this.myVisitor);
        }
    }

    public void doApplyInformationToEditor() {
        if (this.myDocument == null) {
            return;
        }
        List highlights = this.myHolder.stream().map(el -> HighlightInfo.fromAnnotation((Annotation)el)).collect(Collectors.toList());
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), highlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }
}

