/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.validation.FunctionCollector;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.Collection;

public abstract class JSImplementedMethodProcessor
extends JSCollectMembersToImplementProcessor {
    protected final JSClass myJsClass;

    public static Collection<JSFunction> collectFunctionsToImplement(JSClass clazz) {
        final FunctionCollector alreadyUsedMethods = new FunctionCollector();
        JSImplementedMethodProcessor processor = new JSImplementedMethodProcessor(clazz){

            @Override
            protected void addNonimplementedFunction(JSFunction function) {
                if (alreadyUsedMethods.hasFunctionWithTheSameKind(function.getName(), function.getKind())) {
                    return;
                }
                alreadyUsedMethods.add(function);
            }
        };
        JSResolveUtil.processInterfaceMembers(clazz, processor);
        return alreadyUsedMethods.getFunctions();
    }

    public JSImplementedMethodProcessor(JSClass jsClass) {
        super(null, null, false);
        this.myJsClass = jsClass;
    }

    @Override
    protected ResultSink createResultSink() {
        return new CompletionResultSink(this.place);
    }

    @Override
    protected boolean process(SinkResolveProcessor<?> processor) {
        FunctionCollector functionsCollector = null;
        for (PsiElement _function : processor.getResults()) {
            JSFunction o;
            if (!(_function instanceof JSFunction)) continue;
            JSFunction function = (JSFunction)_function;
            String name = function.getName();
            if (functionsCollector == null) {
                functionsCollector = FunctionCollector.collectAllVisibleClassFunctions(this.myJsClass, null, (Function<JSFunction, Boolean>)((Function)jsFunction -> {
                    JSAttributeList attributeList = jsFunction.getAttributeList();
                    if (!JSInheritanceUtil.canHaveSuperMember(attributeList)) {
                        return Boolean.FALSE;
                    }
                    PsiElement parentClass = JSResolveUtil.findParent((PsiElement)jsFunction);
                    if (attributeList != null && attributeList.getAccessType() != JSAttributeList.AccessType.PUBLIC && this.myJsClass != parentClass) {
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }));
            }
            if ((o = functionsCollector.findFunctionWithTheSameKind(name, function.getKind())) == null) {
                JSVariable var;
                if ((function.isGetProperty() || function.isSetProperty()) && (var = (JSVariable)JSInheritanceUtil.findMember(name, this.myJsClass, JSInheritanceUtil.SearchedMemberType.Fields, null, true)) != null && ActionScriptResolveUtil.fieldIsImplicitAccessorMethod(function, var)) continue;
                this.addNonimplementedFunction(function);
                continue;
            }
            this.addImplementedFunction(function, o);
        }
        return true;
    }

    protected void addImplementedFunction(JSFunction interfaceFunction, JSFunction implementationFunction) {
    }

    protected abstract void addNonimplementedFunction(JSFunction var1);
}

