/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui.newclass;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.PublicInheritorFilter;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.ui.JSClassChooserDialog;
import com.intellij.lang.javascript.ui.newclass.CustomVariablesStep;
import com.intellij.lang.javascript.ui.newclass.WizardModel;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainStep
extends AbstractWizardStepEx {
    private final WizardModel myModel;
    protected final Project myProject;
    private final SortedListModel<String> myInterfacesListModel;
    @Nullable
    private Module myModule;
    private final String myPackageNameInitial;
    @Nullable
    private final JSClass myBaseClassifier;
    private final PsiElement myContext;
    private JPanel myPanel;
    private JTextField myClassNameTextField;
    private JLabel myUpDownHint;
    private JSReferenceEditor myPackageCombo;
    private ComboboxWithBrowseButton myTemplateComboWithBrowse;
    private JLabel mySuperClassLabel;
    private JSReferenceEditor mySuperClassField;
    private JLabel myInterfacesLabel;
    private JPanel myInterfacesPanel;
    private JPanel myPlaceholderPanel;
    private static final String DESTINATION_PACKAGE_RECENT_KEY = "CreateActionScriptClassDialog.DESTINATION_PACKAGE_RECENT_KEY";
    private final JBList myInterfacesList;
    private Collection<String> myLastInterfaces;
    private String myLastSuperclass;
    private final String mySuperclassChooserTitle;
    private Collection<String> myUnsetAttributes;
    private final Computable<List<FileTemplate>> myApplicableTemplatesProvider;
    private final EventDispatcher<ChangeListener> myResizeDispatcher;
    static final Object ID = new Object();
    private final JPanel mySpacer;
    private final JLabel myNameLabel;

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/newclass/MainStep", "getStepId"));
        }
        return object;
    }

    @Nullable
    public Object getNextStepId() {
        return this.myUnsetAttributes.isEmpty() ? null : CustomVariablesStep.ID;
    }

    @Nullable
    public Object getPreviousStepId() {
        return null;
    }

    public boolean isComplete() {
        return this.canFinish();
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        this.myModel.setClassName(this.getClassName());
        this.myModel.setPackageName(this.getPackageName());
        this.myModel.setSuperclassFqn(this.getSuperclassFqn());
        this.myModel.setInterfacesFqns(this.myInterfacesListModel.getItems());
        String templateName = ((FileTemplate)this.myTemplateComboWithBrowse.getComboBox().getSelectedItem()).getName();
        this.myModel.setTemplateName(templateName);
        this.myModel.setCustomVariables(templateName, this.myUnsetAttributes);
        if (commitType == AbstractWizardStepEx.CommitType.Finish) {
            this.myPackageCombo.updateRecents();
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public MainStep(WizardModel model, final Project project, @Nullable String initialClassName, boolean isClassNameEditable, String packageName, @Nullable JSClass baseClassifier, boolean baseClassEditable, String templateName, PsiElement context, String superclassChooserTitle, Computable<List<FileTemplate>> applicableTemplatesProvider) {
        super(null);
        String baseInterfaceFqn;
        this.myModel = model;
        this.myProject = project;
        this.myPackageNameInitial = packageName;
        this.myBaseClassifier = baseClassifier;
        this.myContext = context;
        this.mySuperclassChooserTitle = superclassChooserTitle;
        this.myApplicableTemplatesProvider = applicableTemplatesProvider;
        this.createUIComponents();
        this.myPanel = new JPanel(new GridBagLayout());
        this.myNameLabel = new JLabel();
        MainStep.setLabelTextAndMnemonic(this.myNameLabel, JSBundle.message((String)"create.class.name.label", (Object[])new Object[0]));
        Insets insets = new Insets(0, 0, 5, 0);
        this.myPanel.add((Component)this.myNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.myClassNameTextField = new JTextField();
        this.myClassNameTextField.setMinimumSize(new Dimension(300, this.myClassNameTextField.getMinimumSize().height));
        this.myPanel.add((Component)this.myClassNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 15, 2, insets, 0, 0));
        this.myNameLabel.setLabelFor(this.myClassNameTextField);
        this.myUpDownHint = new JLabel();
        this.myPanel.add((Component)this.myUpDownHint, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 5, 5), 0, 0));
        JLabel packageLabel = new JLabel();
        MainStep.setLabelTextAndMnemonic(packageLabel, JSBundle.message((String)"create.class.package.label", (Object[])new Object[0]));
        this.myPanel.add((Component)packageLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.myPanel.add((Component)((Object)this.myPackageCombo), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 15, 2, insets, 0, 0));
        JLabel templateLabel = new JLabel();
        MainStep.setLabelTextAndMnemonic(templateLabel, JSBundle.message((String)"create.class.template.label", (Object[])new Object[0]));
        this.myPanel.add((Component)templateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myTemplateComboWithBrowse = new ComboboxWithBrowseButton();
        this.myPanel.add((Component)this.myTemplateComboWithBrowse, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        templateLabel.setLabelFor(this.myTemplateComboWithBrowse.getChildComponent());
        this.mySpacer = new JPanel();
        this.myPanel.add((Component)this.mySpacer, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mySuperClassLabel = new JLabel();
        MainStep.setLabelTextAndMnemonic(this.mySuperClassLabel, JSBundle.message((String)"create.class.superclass.label", (Object[])new Object[0]));
        this.myPanel.add((Component)this.mySuperClassLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.myPanel.add((Component)((Object)this.mySuperClassField), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 15, 2, insets, 0, 0));
        this.myInterfacesLabel = new JLabel();
        MainStep.setLabelTextAndMnemonic(this.myInterfacesLabel, JSBundle.message((String)"create.class.interfaces.label", (Object[])new Object[0]));
        this.myNameLabel.setMinimumSize(this.mySuperClassLabel.getMinimumSize());
        this.myPanel.add((Component)this.myInterfacesLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myInterfacesPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.myInterfacesPanel, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myPlaceholderPanel = new JPanel();
        this.myPanel.add((Component)this.myPlaceholderPanel, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        UserActivityWatcher w = new UserActivityWatcher();
        w.register((Component)this.myPanel);
        this.myClassNameTextField.setEditable(isClassNameEditable);
        this.myInterfacesListModel = new SortedListModel((o1, o2) -> StringUtil.naturalCompare((String)o1, (String)o2));
        if (this.myBaseClassifier != null && this.myBaseClassifier.isInterface()) {
            baseInterfaceFqn = this.myBaseClassifier.getQualifiedName();
            this.myInterfacesListModel.add((Object)baseInterfaceFqn);
        } else {
            baseInterfaceFqn = null;
        }
        this.myInterfacesList = new JBList(this.myInterfacesListModel);
        if (baseInterfaceFqn != null) {
            this.myInterfacesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (baseInterfaceFqn.equals(value)) {
                        label.setForeground(UIUtil.getLabelDisabledForeground());
                    } else {
                        label.setForeground(UIUtil.getLabelForeground());
                    }
                    return label;
                }
            });
        }
        this.myInterfacesList.disableEmptyText();
        JPanel p = ToolbarDecorator.createDecorator((JList)this.myInterfacesList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                JSClass selected;
                String chooserTitle = JSBundle.message((String)"choose.super.interface.title", (Object[])new Object[0]);
                if (DumbService.getInstance((Project)project).isDumb()) {
                    Messages.showWarningDialog((String)JSBundle.message((String)"class.chooser.not.available.in.dumb.mode", (Object[])new Object[0]), (String)chooserTitle);
                    return;
                }
                JSClassChooserDialog chooser = new JSClassChooserDialog(project, chooserTitle, MainStep.this.getSuperclassScope(), null, (Condition<JSClass>)((Condition)jsClass -> jsClass.isInterface() && MainStep.this.myInterfacesListModel.indexOf((Object)jsClass.getQualifiedName()) == -1));
                if (chooser.showDialog() && (selected = chooser.getSelectedClass()) != null) {
                    MainStep.this.myInterfacesListModel.add((Object)selected.getQualifiedName());
                }
            }
        }).setMoveUpAction(null).setMoveDownAction(null).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return MainStep.this.myBaseClassifier == null || !MainStep.this.myBaseClassifier.isInterface() || !ArrayUtil.contains((Object)MainStep.this.myBaseClassifier.getQualifiedName(), (Object[])MainStep.this.myInterfacesList.getSelectedValues());
            }
        }).setVisibleRowCount(2).createPanel();
        this.myInterfacesPanel.add((Component)p, "Center");
        this.myInterfacesLabel.setLabelFor((Component)this.myInterfacesList);
        p.setMinimumSize(p.getPreferredSize());
        this.initUpDownHint();
        this.fillTemplates(templateName);
        packageLabel.setLabelFor(this.myPackageCombo.getChildComponent());
        packageLabel.setPreferredSize(this.mySuperClassLabel.getPreferredSize());
        this.mySuperClassLabel.setLabelFor((Component)((Object)this.mySuperClassField));
        this.mySuperClassLabel.setText(JSBundle.message((String)"superclass.label.text", (Object[])new Object[0]));
        if (!baseClassEditable && this.myBaseClassifier != null && !this.myBaseClassifier.isInterface()) {
            this.mySuperClassLabel.setEnabled(false);
            this.mySuperClassField.setEnabled(false);
            this.mySuperClassField.setText(this.myBaseClassifier.getQualifiedName());
        }
        this.myTemplateComboWithBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTemplate template = (FileTemplate)MainStep.this.myTemplateComboWithBrowse.getComboBox().getSelectedItem();
                ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                util.editConfigurable(project, (Configurable)new AllFileTemplatesConfigurable(MainStep.this.myProject));
                MainStep.this.fillTemplates(template.getName());
                MainStep.this.updateOnTemplateChange();
                MainStep.this.fireStateChanged();
            }
        });
        this.myTemplateComboWithBrowse.getComboBox().setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof FileTemplate) {
                    this.setText(CreateClassOrInterfaceFix.getTemplateShortName(((FileTemplate)value).getName()));
                    this.setIcon(CreateClassOrInterfaceFix.getTemplateIcon((FileTemplate)value));
                }
            }
        });
        this.myTemplateComboWithBrowse.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MainStep.this.updateOnTemplateChange();
            }
        });
        this.myClassNameTextField.setText(initialClassName);
        this.myResizeDispatcher = EventDispatcher.create(ChangeListener.class);
        this.updateOnTemplateChange();
        w.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                MainStep.this.fireStateChanged();
            }
        });
    }

    protected boolean canFinish() {
        PsiElement elt;
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE);
        if (!namesValidator.isIdentifier(this.getClassName(), this.myProject)) {
            return false;
        }
        String text = this.getPackageName();
        if (text.length() == 0) {
            return true;
        }
        ASTNode node = JSChangeUtil.createJSTreeFromText(this.myProject, text);
        return node != null && (elt = node.getPsi()) instanceof JSExpressionStatement && (elt = ((JSExpressionStatement)elt).getExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)elt).getReferencedName() != null && elt.textMatches((CharSequence)text);
    }

    private void updateOnTemplateChange() {
        String[] unsetAttributes;
        Map<String, Object> properties = CreateClassOrInterfaceFix.createProperties("", "", "");
        FileTemplate template = (FileTemplate)this.myTemplateComboWithBrowse.getComboBox().getSelectedItem();
        try {
            unsetAttributes = FileTemplateUtil.calculateAttributes((String)template.getText(), properties, (boolean)false, (Project)this.myProject);
        }
        catch (Exception ex) {
            unsetAttributes = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        boolean superInterfaces = ArrayUtil.contains((String)"SuperInterfaces", (String[])unsetAttributes);
        boolean changed = false;
        if (superInterfaces) {
            changed = this.myInterfacesPanel.isVisible();
            this.myPlaceholderPanel.setVisible(false);
            this.myInterfacesLabel.setVisible(true);
            this.myInterfacesPanel.setVisible(true);
            if (this.myLastInterfaces != null) {
                this.myInterfacesListModel.addAll(this.myLastInterfaces);
                this.myLastInterfaces = null;
            }
        } else {
            if (this.myInterfacesPanel.isVisible()) {
                this.myLastInterfaces = this.myInterfacesListModel.getItems();
                changed = true;
            }
            this.myInterfacesLabel.setVisible(false);
            this.myInterfacesPanel.setVisible(false);
            this.myPlaceholderPanel.setVisible(true);
            this.myInterfacesListModel.clear();
        }
        if (ArrayUtil.contains((String)"Superclass", (String[])unsetAttributes)) {
            changed |= !this.mySuperClassLabel.isVisible();
            this.mySuperClassLabel.setVisible(true);
            this.mySuperClassField.setVisible(true);
            if (this.myLastSuperclass != null) {
                this.mySuperClassField.setText(this.myLastSuperclass);
                this.myLastSuperclass = null;
            }
        } else {
            if (this.mySuperClassField.isVisible()) {
                this.myLastSuperclass = this.getSuperclassFqn();
                changed = true;
            }
            this.mySuperClassLabel.setVisible(false);
            this.mySuperClassField.setVisible(false);
            this.mySuperClassField.setText(null);
        }
        this.mySpacer.setVisible(this.mySuperClassLabel.isVisible() || this.myInterfacesLabel.isVisible());
        if (changed) {
            ((ChangeListener)this.myResizeDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
        }
        HashSet<String> attrs = new HashSet<String>(Arrays.asList(unsetAttributes));
        attrs.remove("Superclass");
        attrs.remove("SuperInterfaces");
        attrs.remove("NAME");
        attrs.remove("foreach");
        attrs.remove("i");
        this.myUnsetAttributes = attrs;
    }

    public void addListener(@NotNull ChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/ui/newclass/MainStep", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/lang/javascript/ui/newclass/MainStep", "addListener"));
        }
        this.myResizeDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    protected String getSuperclassFqn() {
        return this.mySuperClassField.getText().trim();
    }

    protected boolean isSuperclassFieldEnabled() {
        return this.mySuperClassField.isVisible();
    }

    private void initUpDownHint() {
        if (!this.myClassNameTextField.isEditable()) {
            this.myUpDownHint.setVisible(false);
            return;
        }
        this.myUpDownHint.setText("");
        this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        AnAction arrow = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (e.getInputEvent() instanceof KeyEvent) {
                    int code = ((KeyEvent)e.getInputEvent()).getKeyCode();
                    int delta = code == 40 ? 1 : (code == 38 ? -1 : 0);
                    JComboBox comboBox = MainStep.this.myTemplateComboWithBrowse.getComboBox();
                    int size = comboBox.getModel().getSize();
                    if (size == 0) {
                        return;
                    }
                    int next = comboBox.getSelectedIndex() + delta;
                    if (next < 0 || next >= size) {
                        if (!UISettings.getInstance().CYCLE_SCROLLING) {
                            return;
                        }
                        next = (next + size) % size;
                    }
                    comboBox.setSelectedIndex(next);
                }
            }
        };
        KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);
        KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
        arrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), (JComponent)this.myClassNameTextField);
    }

    private void fillTemplates(String templateName) {
        List applicableTemplates = (List)this.myApplicableTemplatesProvider.compute();
        this.myTemplateComboWithBrowse.getComboBox().setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray((Collection)applicableTemplates)));
        FileTemplate selectedTemplate = (FileTemplate)ContainerUtil.find((Iterable)applicableTemplates, fileTemplate -> fileTemplate.getName().equals(templateName));
        if (selectedTemplate == null && !applicableTemplates.isEmpty()) {
            selectedTemplate = (FileTemplate)applicableTemplates.get(0);
        }
        this.myTemplateComboWithBrowse.getComboBox().setSelectedItem(selectedTemplate);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameTextField.isEditable() ? this.myClassNameTextField : this.myPackageCombo.getChildComponent();
    }

    private String getClassName() {
        return this.myClassNameTextField.getText().trim();
    }

    private String getPackageName() {
        return this.myPackageCombo.getText().trim();
    }

    private void createUIComponents() {
        String fqn;
        Condition filter;
        this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myContext);
        this.myPackageCombo = JSReferenceEditor.forPackageName(this.myPackageNameInitial, this.myProject, DESTINATION_PACKAGE_RECENT_KEY, (GlobalSearchScope)this.myModel.getTargetClassScopeAndBaseDir().first, RefactoringBundle.message((String)"choose.destination.package"));
        this.myPackageCombo.setHeightProvider((Computable<Integer>)((Computable)() -> ((JComboBox)this.myTemplateComboWithBrowse.getChildComponent()).getPreferredSize().height));
        GlobalSearchScope superClassScope = this.getSuperclassScope();
        if (this.myModule == null || this.myBaseClassifier == null || this.myBaseClassifier.isInterface() || !this.filterByBaseClass()) {
            filter = jsClass -> this.canBeSuperClass((JSClass)jsClass);
        } else {
            fqn = this.myBaseClassifier.getQualifiedName();
            filter = new PublicInheritorFilter(this.myProject, fqn, superClassScope, false);
        }
        fqn = StringUtil.notNullize(this.myBaseClassifier != null && !this.myBaseClassifier.isInterface() ? this.myBaseClassifier.getQualifiedName() : null);
        this.mySuperClassField = JSReferenceEditor.forClassName(fqn, this.myProject, null, superClassScope, null, (Condition<JSClass>)filter, this.mySuperclassChooserTitle);
    }

    protected boolean canBeSuperClass(JSClass jsClass) {
        return !jsClass.isInterface() && !jsClass.getAttributeList().hasModifier(JSAttributeList.ModifierType.FINAL);
    }

    public void setSuperclassLabelText(String text) {
        MainStep.setLabelTextAndMnemonic(this.mySuperClassLabel, text);
        this.myNameLabel.setMinimumSize(new Dimension(Math.max(this.mySuperClassLabel.getMinimumSize().width, this.myNameLabel.getMinimumSize().width), this.myNameLabel.getMinimumSize().height));
    }

    private static void setLabelTextAndMnemonic(JLabel label, String text) {
        label.setText(UIUtil.removeMnemonic((String)text));
        label.setDisplayedMnemonic(text.charAt(UIUtil.getDisplayMnemonicIndex((String)text) + 1));
    }

    protected GlobalSearchScope getSuperclassScope() {
        PsiDirectory baseDir = this.myContext instanceof PsiDirectory ? (PsiDirectory)this.myContext : PlatformPackageUtil.getDirectory((PsiElement)this.myContext);
        boolean test = baseDir != null && TestSourcesFilter.isTestSources((VirtualFile)baseDir.getVirtualFile(), (Project)this.myProject);
        return this.myModule == null ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)test);
    }

    protected boolean filterByBaseClass() {
        return true;
    }
}

