/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.embedding.EmbeddedLazyParseableElementType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.impl.JSBlockStatementImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBlockStatementElementType
extends IReparseableElementType {
    public JSBlockStatementElementType() {
        super("BLOCK_STATEMENT", (Language)JavascriptLanguage.INSTANCE, true);
    }

    public boolean isParsable(CharSequence buffer, Language fileLanguage, Project project) {
        IElementType tokenType;
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(fileLanguage)).createLexer(project);
        lexer.start(buffer);
        int bracesCount = 0;
        while ((tokenType = lexer.getTokenType()) != null) {
            if (tokenType == JSTokenTypes.LBRACE) {
                ++bracesCount;
            } else if (tokenType == JSTokenTypes.RBRACE) {
                --bracesCount;
            } else if (bracesCount <= 0) {
                return false;
            }
            lexer.advance();
        }
        return bracesCount == 0;
    }

    @Nullable
    public ASTNode createNode(CharSequence text) {
        return new JSBlockStatementImpl(text);
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        PsiBuilder builder;
        ASTNode embeddedContentParent;
        PsiElement oldParent;
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/lang/javascript/types/JSBlockStatementElementType", "doParseContents"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/JSBlockStatementElementType", "doParseContents"));
        }
        ASTNode oldTree = (ASTNode)Pair.getFirst((Pair)((Pair)chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)));
        if (oldTree instanceof PsiElement && (oldParent = ((PsiElement)oldTree).getParent()) != null) {
            psi = oldParent;
        }
        Project project = psi.getProject();
        Language language = JSLanguageUtil.getLanguageForParser(psi);
        for (embeddedContentParent = chameleon; embeddedContentParent != null && !(embeddedContentParent.getElementType() instanceof EmbeddedLazyParseableElementType); embeddedContentParent = embeddedContentParent.getTreeParent()) {
        }
        if (embeddedContentParent != null) {
            EmbeddedLazyParseableElementType elementType = (EmbeddedLazyParseableElementType)embeddedContentParent.getElementType();
            Lexer lexer = elementType.createLexer(chameleon, project, language);
            builder = elementType.getBuilder(chameleon, project, (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language), lexer);
        } else {
            builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, null, language, chameleon.getChars());
        }
        JavaScriptParser jsParser = language instanceof JSLanguageDialect ? ((JSLanguageDialect)language).createParser(builder) : new JavaScriptParser(null, builder);
        builder.putUserData(JavaScriptParserBase.JS_DIALECT_KEY, (Object)jsParser.getDialect());
        JSFunction parent = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psi, (Class[])new Class[]{JSFunction.class});
        builder.putUserData(FunctionParser.ASYNC_METHOD_KEY, (Object)ES6PsiUtil.isAsyncContext(parent));
        ((FunctionParser)jsParser.getFunctionParser()).putIsGenerator(ES6PsiUtil.isGeneratorContext(parent));
        boolean isFunctionContext = PsiTreeUtil.getNonStrictParentOfType((PsiElement)psi, (Class[])new Class[]{JSFunction.class}) != null;
        PsiBuilder.Marker root = builder.mark();
        StatementParser.BlockType type = isFunctionContext ? StatementParser.BlockType.FUNCTION_BODY : StatementParser.BlockType.BLOCK;
        ((StatementParser)jsParser.getStatementParser()).parseBlockBodyDeeply(type);
        root.done((IElementType)this);
        ASTNode treeBuilt = builder.getTreeBuilt();
        return treeBuilt.getFirstChildNode();
    }

    public boolean reuseCollapsedTokens() {
        return true;
    }
}

