/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateWithExpressionSelector;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.utils.UnnecessaryParenthesesChecker;
import org.jetbrains.annotations.NotNull;

public class JSTypeOfExpressionPostfixTemplate
extends PostfixTemplateWithExpressionSelector {
    public JSTypeOfExpressionPostfixTemplate() {
        super("typeof", "typeof expr", JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset());
    }

    protected void expandForChooseExpression(@NotNull PsiElement expression, @NotNull Editor editor) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/template/postfix/JSTypeOfExpressionPostfixTemplate", "expandForChooseExpression"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/template/postfix/JSTypeOfExpressionPostfixTemplate", "expandForChooseExpression"));
        }
        JSTypeOfExpressionPostfixTemplate.replaceByTypeOf(expression);
    }

    public static PsiElement replaceByTypeOf(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/template/postfix/JSTypeOfExpressionPostfixTemplate", "replaceByTypeOf"));
        }
        PsiElement replacement = expression.replace(JSPostfixTemplateUtils.createExpression(expression, "typeof(", ")"));
        JSParenthesizedExpression parenthesizedExpression = (JSParenthesizedExpression)PsiTreeUtil.getChildOfType((PsiElement)replacement, JSParenthesizedExpression.class);
        assert (parenthesizedExpression != null);
        if (UnnecessaryParenthesesChecker.shouldRemove(parenthesizedExpression)) {
            return replacement.replace(JSPostfixTemplateUtils.createExpression(expression, "typeof ", ""));
        }
        return replacement;
    }
}

