/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSStatementSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/surroundWith/JSStatementSurrounder", "isApplicable"));
        }
        return true;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/surroundWith/JSStatementSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/surroundWith/JSStatementSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/surroundWith/JSStatementSurrounder", "surroundElements"));
        }
        JSLanguageDialect languageDialect = JSUtils.getDialect(elements[0].getContainingFile());
        ASTNode node = JSChangeUtil.createStatementFromText(project, this.getStatementTemplate(project, elements[0]), languageDialect);
        if (elements.length == 1 && elements[0] instanceof JSExpression && this.willWrapExpression()) {
            elements[0] = elements[0].getParent();
        }
        PsiElement container = elements[0].getParent();
        container.getNode().addChild(node, elements[0].getNode());
        ASTNode insertBeforeNode = this.getInsertBeforeNode(node);
        for (int i = 0; i < elements.length; ++i) {
            ASTNode childNode = elements[i].getNode();
            ASTNode childNodeCopy = childNode.copyElement();
            container.getNode().removeChild(childNode);
            insertBeforeNode.getTreeParent().addChild(childNodeCopy, insertBeforeNode);
        }
        node = this.cleanup(node);
        CodeStyleManager csManager = CodeStyleManager.getInstance((Project)project);
        csManager.reformat(node.getPsi());
        csManager.reformatNewlyAddedElement(node.getTreeParent(), node);
        return this.getSurroundSelectionRange(node);
    }

    protected boolean willWrapExpression() {
        return false;
    }

    protected ASTNode cleanup(ASTNode node) {
        return node;
    }

    @NonNls
    protected abstract String getStatementTemplate(Project var1, PsiElement var2);

    protected abstract ASTNode getInsertBeforeNode(ASTNode var1);

    protected abstract TextRange getSurroundSelectionRange(ASTNode var1);
}

