/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.surroundWith.JSWithObjectLiteralSurrounder;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSPropertiesSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new JSWithObjectLiteralSurrounder()};

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        JSProperty property;
        PsiElement element1;
        for (element1 = file.findElementAt(startOffset); element1 != null && (element1 instanceof PsiWhiteSpace || element1.getNode().getElementType() == JSTokenTypes.COMMA); element1 = element1.getNextSibling()) {
        }
        if (element1 != null) {
            startOffset = element1.getTextRange().getStartOffset();
        }
        if ((property = (JSProperty)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, JSProperty.class)) == null || property.getNameIdentifier() == null || property.getValue() == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/surroundWith/JSPropertiesSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<JSProperty> properties = new ArrayList<JSProperty>();
        properties.add(property);
        for (PsiElement nextSibling = property.getNextSibling(); nextSibling != null && nextSibling.getTextRange().getEndOffset() <= endOffset; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof JSProperty)) continue;
            properties.add((JSProperty)nextSibling);
        }
        PsiElement[] psiElementArray = properties.toArray(new PsiElement[properties.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/surroundWith/JSPropertiesSurroundDescriptor", "getElementsToSurround"));
        }
        return psiElementArray;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        if (SURROUNDERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/surroundWith/JSPropertiesSurroundDescriptor", "getSurrounders"));
        }
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }
}

