/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ui;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSConsoleViewPanel;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.StatusText;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowManager
implements Disposable,
JSLanguageService.ProcessConnector {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    public static final String WARNING = "warning";
    public static final String FIRST_PROJECT_RUN = "typescript.language.service.tool.window.force.activate";
    public static final String EMPTY_TEXT = " ";
    @NotNull
    protected final Project myProject;
    @Nullable
    protected volatile NewErrorTreeViewPanel myCurrentErrorTreeViewPanel;
    private volatile NewErrorTreeViewPanel myProjectErrorTreeViewPanel;
    private volatile boolean myInitialized;
    @Nullable
    private ConsoleView myConsoleView;
    @Nullable
    private ContentImpl myConsoleContent;
    @Nullable
    private volatile ToolWindow myToolWindow;
    private String myHelpId;
    @Nullable
    private final LayeredIcon myIcon;
    @Nullable
    private final Icon myErrorIcon;
    @Nullable
    private AnAction[] myCommonActions;
    @NotNull
    private final String myToolWindowName;
    @Nullable
    private volatile List<JSLanguageServiceAnnotationResult> myLastResult;

    public JSLanguageServiceToolWindowManager(@NotNull Project project, @NotNull String toolWindowName, @NotNull String helpId, @Nullable Icon icon, AnAction ... commonPanelActions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "<init>"));
        }
        if (toolWindowName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowName", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "<init>"));
        }
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "<init>"));
        }
        this.myProject = project;
        this.myToolWindowName = toolWindowName;
        this.myHelpId = helpId;
        this.myCommonActions = commonPanelActions;
        this.myIcon = JSLanguageServiceToolWindowManager.createIcon(icon, false);
        this.myErrorIcon = JSLanguageServiceToolWindowManager.createIcon(icon, true);
    }

    private static LayeredIcon createIcon(@Nullable Icon rawIcon, boolean error) {
        if (rawIcon == null) {
            return null;
        }
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(rawIcon, 0);
        Icon errorMark = AllIcons.Nodes.ErrorMark;
        icon.setIcon(error ? errorMark : EmptyIcon.create((Icon)errorMark), 1, 5);
        return icon;
    }

    public boolean needActivateProgressPanel() {
        return false;
    }

    public void setProgressText(@Nullable String text) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel myErrorPanel = this.myCurrentErrorTreeViewPanel;
        if (myErrorPanel != null) {
            if (StringUtil.isEmpty((String)text)) {
                myErrorPanel.clearProgressData();
            } else {
                myErrorPanel.setProgressText(text);
            }
        }
    }

    @Override
    public synchronized void connectToProcessHandler(@NotNull ProcessHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "connectToProcessHandler"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.init();
        NewErrorTreeViewPanel errorTreeViewPanel = this.createOrGetCurrentTreeViewPanel();
        if (errorTreeViewPanel != null) {
            errorTreeViewPanel.getErrorViewStructure().clear();
        }
        LOGGER.debug("creating tool window");
        assert (this.myToolWindow != null);
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            this.myConsoleView = this.createConsole();
            this.myConsoleView.attachToProcess(handler);
            JSConsoleViewPanel panel = new JSConsoleViewPanel(this.myProject, this.myHelpId, null, this.myConsoleView, this.myCommonActions);
            this.myConsoleContent = new ContentImpl((JComponent)panel, "Console", false);
            toolWindow.getContentManager().addContent((Content)this.myConsoleContent);
        }
    }

    @Override
    @NotNull
    public String getServiceName() {
        String string = this.myToolWindowName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "getServiceName"));
        }
        return string;
    }

    @NotNull
    protected ConsoleViewImpl createConsole() {
        ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false);
        if (consoleViewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "createConsole"));
        }
        return consoleViewImpl;
    }

    public synchronized void printToConsole(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "printToConsole"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ConsoleView view = this.myConsoleView;
        if (view != null) {
            view.print(message, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    public synchronized boolean isConnectedToProcessHandler() {
        return this.myConsoleView != null;
    }

    public void show() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            toolWindow.show(null);
        }
    }

    public synchronized void init() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myInitialized || this.myToolWindow == null) {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = manager.registerToolWindow(this.myToolWindowName, true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
            toolWindow.setIcon((Icon)this.myIcon);
            this.myToolWindow = toolWindow;
            this.myInitialized = true;
            LOGGER.debug("initialized tool window");
            this.createOrGetCurrentTreeViewPanel();
        }
    }

    private ContentImpl createCurrentErrorContent(ToolWindow toolWindow) {
        Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = this.createCurrentErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        content.set((Object)new ContentImpl((JComponent)((Object)errorTreeViewPanel), this.getCurrentErrorsTitle(), false));
        toolWindow.getContentManager().addContent((Content)content.get(), 0);
        this.myCurrentErrorTreeViewPanel = errorTreeViewPanel;
        return (ContentImpl)content.get();
    }

    @NotNull
    protected String getCurrentErrorsTitle() {
        if ("Errors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "getCurrentErrorsTitle"));
        }
        return "Errors";
    }

    @NotNull
    protected String getProjectErrorsTitle() {
        if ("Project Errors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "getProjectErrorsTitle"));
        }
        return "Project Errors";
    }

    @NotNull
    protected JSLanguageServiceErrorTreeViewPanel createCurrentErrorsPanel(final ToolWindow toolWindow, final Ref<ContentImpl> content) {
        JSLanguageServiceErrorTreeViewPanel panel = new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, () -> {
            this.myLastResult = null;
        }, this.getErrorPanelLeftActions(false), this.getErrorPanelRightActions(false)){

            public void close() {
                JSLanguageServiceToolWindowManager.this.closeCurrentErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
            }
        };
        if (this.needActivateProgressPanel()) {
            panel.setProgressText(EMPTY_TEXT);
        }
        this.updateCurrentErrorsEmptyText(panel);
        JSLanguageServiceErrorTreeViewPanel jSLanguageServiceErrorTreeViewPanel = panel;
        if (jSLanguageServiceErrorTreeViewPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "createCurrentErrorsPanel"));
        }
        return jSLanguageServiceErrorTreeViewPanel;
    }

    protected void closeCurrentErrorsPanel(ToolWindow toolWindow, Ref<ContentImpl> content) {
        toolWindow.hide(() -> {
            this.myLastResult = null;
            toolWindow.setIcon((Icon)this.myIcon);
            ContentImpl contentImpl = (ContentImpl)content.get();
            if (contentImpl != null) {
                toolWindow.getContentManager().removeContent((Content)contentImpl, true);
            }
            ContentImpl newContentImpl = this.createCurrentErrorContent(toolWindow);
            toolWindow.getContentManager().setSelectedContent((Content)newContentImpl);
        });
    }

    protected AnAction[] getErrorPanelRightActions(boolean all) {
        return AnAction.EMPTY_ARRAY;
    }

    protected AnAction[] getErrorPanelLeftActions(boolean all) {
        return this.myCommonActions;
    }

    public void setName(@Nullable String newName) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.init();
        ToolWindow window = this.myToolWindow;
        if (window != null && !StringUtil.isEmptyOrSpaces((String)newName)) {
            window.setStripeTitle(this.myToolWindowName + EMPTY_TEXT + newName);
        }
    }

    @Nullable
    private NewErrorTreeViewPanel createProjectErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myProjectErrorTreeViewPanel;
        if (panel != null) {
            return panel;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            return null;
        }
        Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = this.createProjectErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        content.set((Object)new ContentImpl((JComponent)((Object)errorTreeViewPanel), this.getProjectErrorsTitle(), false));
        toolWindow.getContentManager().addContent((Content)content.get());
        this.myProjectErrorTreeViewPanel = errorTreeViewPanel;
        return errorTreeViewPanel;
    }

    @NotNull
    protected JSLanguageServiceErrorTreeViewPanel createProjectErrorsPanel(final ToolWindow toolWindow, final Ref<ContentImpl> content) {
        JSLanguageServiceErrorTreeViewPanel jSLanguageServiceErrorTreeViewPanel = new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, null, this.getErrorPanelLeftActions(true), this.getErrorPanelRightActions(true)){

            public void close() {
                NewErrorTreeViewPanel oldPanel = JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel;
                JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel = null;
                toolWindow.hide(() -> {
                    ContentImpl contentImpl = (ContentImpl)content.get();
                    if (contentImpl != null) {
                        toolWindow.getContentManager().removeContent((Content)contentImpl, true);
                    }
                    if (oldPanel != null) {
                        Disposer.dispose((Disposable)oldPanel);
                    }
                });
            }
        };
        if (jSLanguageServiceErrorTreeViewPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "createProjectErrorsPanel"));
        }
        return jSLanguageServiceErrorTreeViewPanel;
    }

    @Override
    public void disconnectFromProcessHandler() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ConsoleView console = this.myConsoleView;
        ContentImpl content = this.myConsoleContent;
        ToolWindow toolWindow = this.myToolWindow;
        if (console != null && content != null && toolWindow != null) {
            toolWindow.getContentManager().removeContent((Content)content, true);
            this.myConsoleView = null;
            this.myConsoleContent = null;
            Disposer.dispose((Disposable)console);
        }
    }

    public void logProjectErrors(@NotNull ImmutableList<JSLanguageServiceAnnotationResult> results, boolean setActive) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "logProjectErrors"));
        }
        NewErrorTreeViewPanel panel = this.createProjectErrorsPanel();
        if (panel == null) {
            return;
        }
        JSLanguageServiceToolWindowManager.logErrorsImpl(panel, results);
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        if (setActive) {
            this.setActivePanel(panel, window);
        }
    }

    private void setActivePanel(NewErrorTreeViewPanel panel, ToolWindow window) {
        for (Content content : window.getContentManager().getContents()) {
            if (content.getComponent() != panel) continue;
            window.getContentManager().setSelectedContent(content);
            break;
        }
        this.show();
    }

    protected NewErrorTreeViewPanel createOrGetCurrentTreeViewPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel errorTreeViewPanel = this.myCurrentErrorTreeViewPanel;
        if (errorTreeViewPanel != null) {
            return errorTreeViewPanel;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (this.myInitialized && toolWindow != null) {
            ContentImpl content = this.createCurrentErrorContent(toolWindow);
            toolWindow.getContentManager().setSelectedContent((Content)content);
        }
        return this.myCurrentErrorTreeViewPanel;
    }

    public void logCurrentErrors(@NotNull List<JSLanguageServiceAnnotationResult> results, boolean setActive) {
        ArrayList list;
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "logCurrentErrors"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel errorTreeViewPanel = this.createOrGetCurrentTreeViewPanel();
        if (errorTreeViewPanel == null) {
            return;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (this.myInitialized && !(list = ContainerUtil.newArrayList(results)).equals(this.myLastResult)) {
            JSLanguageServiceToolWindowManager.logErrorsImpl(errorTreeViewPanel, list);
            this.myLastResult = list;
            if (toolWindow != null && this.myIcon != null) {
                Object newIcon;
                Icon oldIcon = toolWindow.getIcon();
                Object object = newIcon = list.isEmpty() ? this.myIcon : this.myErrorIcon;
                if (oldIcon != newIcon) {
                    toolWindow.setIcon((Icon)newIcon);
                }
            }
        }
        if (toolWindow != null && setActive) {
            this.setActivePanel(errorTreeViewPanel, toolWindow);
        }
    }

    private static void logErrorsImpl(NewErrorTreeViewPanel errorTreeViewPanel, List<JSLanguageServiceAnnotationResult> list) {
        errorTreeViewPanel.getErrorViewStructure().clear();
        for (JSLanguageServiceAnnotationResult compilerResult : list) {
            String path = compilerResult.getFileAbsoluteSystemDependPath();
            VirtualFile file = null;
            if (path != null) {
                file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
            }
            int category = WARNING.equalsIgnoreCase(compilerResult.getCategory()) ? 5 : 4;
            errorTreeViewPanel.addMessage(category, new String[]{compilerResult.getErrorText()}, file, compilerResult.getLine(), compilerResult.getColumn(), null);
        }
        errorTreeViewPanel.updateTree();
    }

    public void dispose() {
        this.cleanPanel();
    }

    public void cleanProjectErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myProjectErrorTreeViewPanel;
        if (panel != null) {
            panel.getErrorViewStructure().clear();
            panel.updateTree();
        }
    }

    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "updateCurrentErrorsEmptyText"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        StatusText text = panel.getEmptyText();
        text.setText(JSLanguageServiceErrorTreeViewPanel.getDefaultNoErrorsText());
    }

    public synchronized void cleanPanel() {
        NewErrorTreeViewPanel allErrorTreeViewPanel;
        ConsoleView view;
        NewErrorTreeViewPanel panel;
        if (this.myProject.isDefault()) {
            return;
        }
        if (!this.myProject.isDisposed()) {
            ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(this.myToolWindowName);
        }
        if ((panel = this.myCurrentErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)panel);
        }
        if ((view = this.myConsoleView) != null) {
            Disposer.dispose((Disposable)view);
        }
        if ((allErrorTreeViewPanel = this.myProjectErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)allErrorTreeViewPanel);
        }
        this.myConsoleView = null;
        this.myProjectErrorTreeViewPanel = null;
        this.myToolWindow = null;
        this.myConsoleContent = null;
        this.myCurrentErrorTreeViewPanel = null;
        this.myLastResult = null;
    }
}

