/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceAnswer {
    public static final String COMMAND = "command";
    public static final String SEQ = "request_seq";
    public static final String NO_INFO_FLAG = "noInfo";
    @NotNull
    private JsonElement myElement;

    public JSLanguageServiceAnswer(String s) {
        this.myElement = new JsonParser().parse(s);
        assert (this.myElement.isJsonObject());
    }

    @Nullable
    public String getCommand() {
        JsonObject object = this.myElement.getAsJsonObject();
        JsonElement element = object.get(COMMAND);
        return element == null ? null : element.getAsString();
    }

    @Nullable
    public Integer getSeq() {
        JsonObject object = this.myElement.getAsJsonObject();
        JsonElement element = object.get(SEQ);
        return element == null ? null : Integer.valueOf(element.getAsInt());
    }

    @NotNull
    public JsonObject getElement() {
        JsonObject jsonObject = (JsonObject)this.myElement;
        if (jsonObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer", "getElement"));
        }
        return jsonObject;
    }

    public boolean isEmpty() {
        return this.getElement().has(NO_INFO_FLAG);
    }

    public String toString() {
        return "JSLanguageCompilerAnswer{myElement=" + this.myElement + '}';
    }
}

