/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.google.gson.Gson;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceImpl
implements JSLanguageService {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    private static final String UNKNOWN_NAME = "unknown";
    public static final Gson GSON = new Gson();
    private final Object myLock;
    private final ExecutorService myExecutorService;
    @NotNull
    private final JSLanguageServiceCacheData myCacheData;
    @NotNull
    private final JSLanguageService.ServiceInfoReporter myReporter;
    @Nullable
    private ProcessHandler myProcessHandler;
    @NotNull
    private final JSLanguageServiceProtocol myProtocol;
    private final Project myProject;
    private volatile String myStartErrorMessage;
    @Nullable
    private final JSLanguageService.ProcessConnector myProcessConnector;
    private boolean myDisposed;
    @NotNull
    private final LowMemoryWatcher myLowMemoryWatcher;
    @NotNull
    private volatile JSLanguageService.State myState;
    @Nullable
    private volatile BackgroundableProcessIndicator myIndicator;

    public JSLanguageServiceImpl(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @Nullable JSLanguageService.ProcessConnector connector, @NotNull JSLanguageService.ServiceInfoReporter reporter, @NotNull JSLanguageServiceCacheData cacheData) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "<init>"));
        }
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "<init>"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "<init>"));
        }
        if (cacheData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cacheData", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "<init>"));
        }
        this.myLock = new Object();
        this.myDisposed = false;
        this.myState = JSLanguageService.State.STARTING;
        this.myReporter = reporter;
        this.myLowMemoryWatcher = LowMemoryWatcher.register(this::resetCaches);
        this.myCacheData = cacheData;
        this.myProject = project;
        this.myProcessConnector = connector;
        this.myProtocol = protocol;
        String serviceName = connector != null ? connector.getServiceName() : UNKNOWN_NAME;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("JS external service " + serviceName));
        this.init();
    }

    @Override
    @NotNull
    public JSLanguageService.State getState() {
        JSLanguageService.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "getState"));
        }
        return state;
    }

    public void init() {
        LOGGER.debug("Submit init action to thread pool");
        this.myExecutorService.submit(() -> {
            Runnable runnable = () -> {
                try {
                    LOGGER.debug("Start service in thread pool");
                    this.startService();
                    Object object = this.myLock;
                    synchronized (object) {
                        if (LOGGER.isDebugEnabled() && this.myProcessHandler != null) {
                            LOGGER.debug("Language service successfully started");
                        }
                    }
                }
                catch (Throwable e) {
                    this.myStartErrorMessage = e.getLocalizedMessage();
                }
                finally {
                    this.createUI();
                }
            };
            BackgroundableProcessIndicator indicator = this.createIndicator();
            Object object = this.myLock;
            synchronized (object) {
                if (this.getState() == JSLanguageService.State.DISPOSED && indicator != null) {
                    JSLanguageServiceImpl.disposeIndicator(indicator);
                } else {
                    this.myIndicator = indicator;
                }
            }
            if (this.myIndicator != null) {
                ProgressManager.getInstance().runProcess(runnable, (ProgressIndicator)this.myIndicator);
            } else {
                runnable.run();
            }
        });
    }

    private BackgroundableProcessIndicator createIndicator() {
        if (this.myProcessConnector == null) {
            return null;
        }
        return (BackgroundableProcessIndicator)UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myProject.isDisposed() || !this.myProject.isOpen() || this.getState() == JSLanguageService.State.DISPOSED) {
                return null;
            }
            return new BackgroundableProcessIndicator(this.myProject, "Starting " + this.myProcessConnector.getServiceName() + " Service", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false);
        });
    }

    private void createUI() {
        ReadAction.run(() -> StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            ProcessHandler handler;
            JSLanguageService.ProcessConnector connector = this.myProcessConnector;
            Object object = this.myLock;
            synchronized (object) {
                handler = this.myProcessHandler;
                if (this.myProject.isDisposed() || this.myDisposed) {
                    return;
                }
            }
            if (handler == null || this.getState() != JSLanguageService.State.STARTED) {
                String errorText = this.myStartErrorMessage == null ? "Cannot start language service process" : this.myStartErrorMessage;
                this.myReporter.logError(errorText);
            } else {
                if (connector != null) {
                    connector.connectToProcessHandler(handler);
                }
                if (!handler.isStartNotified()) {
                    handler.startNotify();
                }
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startService() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                LOGGER.debug("Creating OS Handler");
                this.myProcessHandler = this.myProtocol.connect();
                if (this.myProcessHandler == null) {
                    this.myState = JSLanguageService.State.ERROR_OR_TIMEOUT;
                    this.myStartErrorMessage = this.myProtocol.getInitializeError();
                    return;
                }
                this.myState = JSLanguageService.State.STARTED;
                this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        if (outputType == ProcessOutputTypes.STDERR) {
                            LOGGER.debug("Stderr output: " + event.getText());
                            return;
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            LOGGER.trace("Stdout output: " + event.getText());
                        }
                    }

                    public void processTerminated(ProcessEvent event) {
                        if (JSLanguageServiceImpl.this.myState == JSLanguageService.State.STARTED || JSLanguageServiceImpl.this.myState == JSLanguageService.State.STARTING) {
                            JSLanguageServiceImpl.this.myState = JSLanguageService.State.ERROR_OR_TIMEOUT;
                        }
                    }
                });
                LOGGER.debug("OS Handler created successfully");
            }
            catch (Exception e) {
                this.myState = JSLanguageService.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = e.getLocalizedMessage();
                LOGGER.debug("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.myProcessHandler != null && this.myState == JSLanguageService.State.ERROR_OR_TIMEOUT) {
                    this.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.stop();
            this.myDisposed = true;
        }
    }

    @Override
    @Nullable
    public <T> Future<T> executeWithCache(@NotNull JSLanguageServiceCacheableCommand<T> input, @NotNull JSLanguageServiceCacheableCommandProcessor<T> processor) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "executeWithCache"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "executeWithCache"));
        }
        try {
            return this.myExecutorService.submit(() -> {
                if (input == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$executeWithCache$6"));
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$executeWithCache$6"));
                }
                if (this.myState != JSLanguageService.State.STARTED) {
                    return null;
                }
                try {
                    long startTime = System.currentTimeMillis();
                    Object valueFromCache = this.myCacheData.getValueFromCache(input);
                    if (valueFromCache != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Used service cache " + input);
                        }
                        Object t = processor.processFromCache(input, valueFromCache);
                        return t;
                    }
                    JSLanguageServiceObject objectToSend = this.myCacheData.updateCacheAndGetServiceObject(input);
                    if (objectToSend == null) {
                        LOGGER.debug("Skip processing: " + input);
                        Object var7_8 = null;
                        return var7_8;
                    }
                    this.startAction(input);
                    JSLanguageServiceAnswer answer = this.await(input, objectToSend);
                    if (answer == null || answer.isEmpty() || this.myState != JSLanguageService.State.STARTED) {
                        LOGGER.debug("There is no result");
                        this.myCacheData.putCacheValue(input, answer, null);
                        Object var8_10 = null;
                        return var8_10;
                    }
                    Object result = processor.process(input, objectToSend, answer);
                    this.myCacheData.putCacheValue(input, answer, result);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Total process " + input.getCommand() + " time, millis: " + (System.currentTimeMillis() - startTime));
                    }
                    Object t = result;
                    return t;
                }
                catch (Throwable err) {
                    LOGGER.error(err.getMessage(), err);
                }
                finally {
                    this.endAction(input);
                }
                return null;
            });
        }
        catch (RejectedExecutionException exception) {
            LOGGER.warn(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    @Nullable
    public <T> Future<T> execute(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandResultProcessor<T> processor) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "execute"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "execute"));
        }
        try {
            return this.myExecutorService.submit(() -> {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$execute$7"));
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$execute$7"));
                }
                if (this.myState != JSLanguageService.State.STARTED) {
                    return null;
                }
                try {
                    long startTime = System.currentTimeMillis();
                    JSLanguageServiceObject serviceObject = this.myCacheData.updateCacheAndGetServiceObject(command);
                    if (serviceObject == null) {
                        Object var6_5 = null;
                        return var6_5;
                    }
                    this.startAction(command);
                    JSLanguageServiceAnswer answer = this.await(command, serviceObject);
                    if (this.myState != JSLanguageService.State.STARTED) {
                        Object var7_7 = null;
                        return var7_7;
                    }
                    if (answer != null) {
                        Object process = processor.process(serviceObject, answer);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Total process " + command.getCommand() + " time, millis: " + (System.currentTimeMillis() - startTime));
                        }
                        Object t = process;
                        return t;
                    }
                    Object var7_9 = null;
                    return var7_9;
                }
                finally {
                    this.endAction(command);
                }
            });
        }
        catch (RejectedExecutionException exception) {
            LOGGER.warn(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public void executeNoBlocking(final @NotNull JSLanguageServiceCommand command, final @Nullable Consumer<JSLanguageServiceAnswer> consumer) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "executeNoBlocking"));
        }
        try {
            this.myExecutorService.submit(() -> {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "lambda$executeNoBlocking$8"));
                }
                if (this.myState != JSLanguageService.State.STARTED) {
                    return;
                }
                this.startAction(command);
                try {
                    final long startTime = System.currentTimeMillis();
                    JSLanguageServiceObject data = this.myCacheData.updateCacheAndGetServiceObject(command);
                    if (data == null) {
                        return;
                    }
                    String json = GSON.toJson((Object)data);
                    LOGGER.debug("Send data for: " + command.getCommand());
                    this.sendData(command, json, consumer == null ? null : new JSLanguageServiceAnswerConsumer(){

                        @Override
                        public void consume(JSLanguageServiceAnswer message) {
                            if (JSLanguageServiceImpl.this.myState != JSLanguageService.State.STARTED) {
                                return;
                            }
                            JSLanguageServiceImpl.this.endAction(command);
                            if (message != null) {
                                consumer.consume((Object)message);
                                LOGGER.debug("Total process non-blocking command " + command.getCommand() + " time, millis: " + (System.currentTimeMillis() - startTime));
                            }
                        }
                    });
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    LOGGER.error(throwable.getMessage(), throwable);
                }
            });
        }
        catch (RejectedExecutionException exception) {
            LOGGER.warn(exception.getMessage(), (Throwable)exception);
        }
    }

    @Nullable
    private JSLanguageServiceAnswer await(JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "await"));
        }
        try {
            String json = GSON.toJson((Object)data);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start await \"" + command.getCommand() + "\"");
            }
            final CountDownLatch latch = new CountDownLatch(1);
            final Ref ref = new Ref();
            Object cancellationToken = this.sendData(command, json, new JSLanguageServiceAnswerConsumer(){

                @Override
                public void consume(JSLanguageServiceAnswer message) {
                    ref.set((Object)message);
                    latch.countDown();
                }
            });
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                this.myProtocol.cancelCommand(cancellationToken);
                LOGGER.warn("JavaScript Language Service: IDE-side timeout waiting answer for " + command.getCommand());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Language Service answer was received: " + command.getCommand());
            }
            return (JSLanguageServiceAnswer)ref.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (Throwable err) {
            LOGGER.error(err.getMessage(), err);
        }
        return null;
    }

    private Object sendData(@NotNull JSLanguageServiceCommand command, @NotNull String dataChunk, @Nullable JSLanguageServiceAnswerConsumer consumer) throws Exception {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "sendData"));
        }
        if (dataChunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataChunk", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "sendData"));
        }
        return this.myProtocol.sendCommand(command, dataChunk, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == JSLanguageService.State.DISPOSED) {
                return;
            }
            this.myState = JSLanguageService.State.DISPOSED;
            JSLanguageServiceImpl.disposeIndicator(this.myIndicator);
            this.myExecutorService.shutdownNow();
            try {
                this.myExecutorService.awaitTermination(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.myLowMemoryWatcher.stop();
            Disposer.dispose((Disposable)this.myCacheData);
            Disposer.dispose((Disposable)this.myProtocol);
            this.resetCaches();
            if (this.myProcessHandler != null) {
                if (!this.myProcessHandler.isProcessTerminated()) {
                    this.myProcessHandler.destroyProcess();
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myProcessConnector != null) {
                        this.myProcessConnector.disconnectFromProcessHandler();
                    }
                });
            }
        }
    }

    private void startAction(@NotNull JSLanguageServiceCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "startAction"));
        }
        String text = command.getPresentableText(this.myProject);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        this.myReporter.setProcess(text);
    }

    private void endAction(@NotNull JSLanguageServiceCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceImpl", "endAction"));
        }
        if (this.getState() == JSLanguageService.State.STARTED) {
            this.myReporter.setProcess(null);
        }
    }

    private static void disposeIndicator(@Nullable BackgroundableProcessIndicator indicator) {
        try {
            if (indicator != null) {
                if (!indicator.isCanceled()) {
                    indicator.cancel();
                }
                Disposer.dispose((Disposable)indicator);
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void resetCaches() {
        this.myCacheData.clear();
    }
}

