/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.search.JSMemberSearchParameters;
import com.intellij.lang.javascript.search.JSMembersSearchImpl;
import com.intellij.util.Query;
import com.intellij.util.QueryFactory;

public abstract class JSFunctionsSearch {
    static final QueryFactory<JSFunction, JSMemberSearchParameters<JSFunction>> OVERRIDDEN_FUNCTIONS_QUERY_FACTORY = new QueryFactory();
    static final QueryFactory<JSFunction, JSMemberSearchParameters<JSFunction>> IMPLEMENTING_FUNCTIONS_QUERY_FACTORY = new QueryFactory();

    public static Query<JSFunction> searchOverridingFunctions(JSFunction baseFunction, boolean checkDeepInheritance) {
        JSMemberSearchParameters<JSFunction> parameters = new JSMemberSearchParameters<JSFunction>(baseFunction, checkDeepInheritance);
        return OVERRIDDEN_FUNCTIONS_QUERY_FACTORY.createUniqueResultsQuery(parameters);
    }

    public static Query<JSFunction> searchImplementingFunctions(JSFunction baseFunction, boolean checkDeepInheritance) {
        JSMemberSearchParameters<JSFunction> parameters = new JSMemberSearchParameters<JSFunction>(baseFunction, checkDeepInheritance);
        return IMPLEMENTING_FUNCTIONS_QUERY_FACTORY.createUniqueResultsQuery(parameters);
    }

    static {
        OVERRIDDEN_FUNCTIONS_QUERY_FACTORY.registerExecutor(new JSMembersSearchImpl.JSOverridingMembersSearch());
        IMPLEMENTING_FUNCTIONS_QUERY_FACTORY.registerExecutor(new JSMembersSearchImpl.JSImplementingMembersSearch());
    }
}

