/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.ui;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.ui.RowIcon;
import java.util.Collection;
import javax.swing.Icon;

public class JSMemberSelectionTable
extends AbstractMemberSelectionTable<JSAttributeListOwner, JSMemberInfo> {
    public JSMemberSelectionTable(Collection<JSMemberInfo> memberInfos, MemberInfoModel<JSAttributeListOwner, JSMemberInfo> memberInfoModel, String abstractColumnHeader) {
        super(memberInfos, memberInfoModel, abstractColumnHeader);
    }

    protected Object getAbstractColumnValue(JSMemberInfo memberInfo) {
        if (!(memberInfo.getMember() instanceof JSFunction)) {
            return null;
        }
        if (memberInfo.isStatic()) {
            return null;
        }
        if (!this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)memberInfo)) {
            return this.myMemberInfoModel.isAbstractWhenDisabled((MemberInfoBase)memberInfo);
        }
        return memberInfo.isToAbstract() ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean isAbstractColumnEditable(int rowIndex) {
        return false;
    }

    protected void setVisibilityIcon(JSMemberInfo memberInfo, RowIcon icon) {
    }

    protected Icon getOverrideIcon(JSMemberInfo memberInfo) {
        JSElement member = (JSElement)memberInfo.getMember();
        Icon overrideIcon = EMPTY_OVERRIDE_ICON;
        if (member instanceof JSFunction) {
            if (Boolean.TRUE.equals(memberInfo.getOverrides())) {
                overrideIcon = AllIcons.General.OverridingMethod;
            } else if (Boolean.FALSE.equals(memberInfo.getOverrides())) {
                overrideIcon = AllIcons.General.ImplementingMethod;
            }
        }
        return overrideIcon;
    }

    protected Icon getMemberIcon(JSMemberInfo memberInfo, int flags) {
        JSFunction method;
        if (memberInfo.getMember() instanceof JSFunction && ((method = (JSFunction)memberInfo.getMember()).getKind() == JSFunction.FunctionKind.GETTER || method.getKind() == JSFunction.FunctionKind.SETTER)) {
            Icon propertyIcon = JSFormatUtil.getPropertyIcon(method, true);
            return ElementBase.buildRowIcon((Icon)propertyIcon, (Icon)method.getAttributeList().getAccessType().getIcon());
        }
        return super.getMemberIcon((MemberInfoBase)memberInfo, flags);
    }
}

