/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPushDown;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSClassMemberReferencesVisitor;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JSPushDownConflictsUtil {
    public static MultiMap<PsiElement, String> checkConflicts(JSClass sourceClass, JSMemberInfo[] memberInfos, Collection<JSClass> targetClasses, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownConflictsUtil", "checkConflicts"));
        }
        MultiMap conflicts = new MultiMap();
        HashSet<JSAttributeListOwner> movedMembers = new HashSet<JSAttributeListOwner>();
        HashSet<JSAttributeListOwner> abstractMembers = new HashSet<JSAttributeListOwner>();
        for (JSMemberInfo jSMemberInfo : memberInfos) {
            JSAttributeListOwner member = (JSAttributeListOwner)jSMemberInfo.getMember();
            if (!jSMemberInfo.isChecked() || jSMemberInfo.getMember() instanceof JSClass) continue;
            movedMembers.add(member);
            if (!jSMemberInfo.isToAbstract()) continue;
            abstractMembers.add(member);
        }
        for (JSMemberInfo jSMemberInfo : sourceClass.getFunctions()) {
            if (movedMembers.contains((Object)jSMemberInfo)) continue;
            JSPushDownConflictsUtil.checkIncomingRefsFromUntouchedMember(sourceClass, movedMembers, abstractMembers, (JSAttributeListOwner)jSMemberInfo, (MultiMap<PsiElement, String>)conflicts);
        }
        for (JSMemberInfo jSMemberInfo : sourceClass.getFields()) {
            if (movedMembers.contains((Object)jSMemberInfo)) continue;
            JSPushDownConflictsUtil.checkIncomingRefsFromUntouchedMember(sourceClass, movedMembers, abstractMembers, (JSAttributeListOwner)jSMemberInfo, (MultiMap<PsiElement, String>)conflicts);
        }
        if (JSPushDownConflictsUtil.checkIncomingReferencesToBaseClassExist(sourceClass, movedMembers)) {
            conflicts.putValue((Object)sourceClass, (Object)RefactoringBundle.message((String)"pushed.members.will.not.be.visible.from.certain.call.sites"));
        }
        HashSet<PsiElement> reported = new HashSet<PsiElement>();
        for (JSClass targetClass : targetClasses) {
            for (JSAttributeListOwner movedMember : movedMembers) {
                JSPushDownConflictsUtil.checkMemberExistsInTargetClass(sourceClass, targetClass, movedMember, (MultiMap<PsiElement, String>)conflicts);
            }
            for (JSAttributeListOwner member : movedMembers) {
                JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)member, (PsiElement)member, movedMembers, (PsiElement)targetClass, true, (MultiMap<PsiElement, String>)conflicts, (Condition<PsiElement>)Conditions.alwaysTrue(), reported, options);
            }
        }
        return conflicts;
    }

    private static void checkIncomingRefsFromUntouchedMember(JSClass sourceClass, final Collection<JSAttributeListOwner> movedMembers, final Collection<JSAttributeListOwner> toMakeAbstract, final JSAttributeListOwner untouchedMember, final MultiMap<PsiElement, String> conflicts) {
        untouchedMember.accept((PsiElementVisitor)new JSClassMemberReferencesVisitor(sourceClass){

            @Override
            protected void visitMemberReference(JSAttributeListOwner member, JSReferenceExpression reference) {
                if (PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)reference, (boolean)false)) {
                    return;
                }
                if (movedMembers.contains(member) && !toMakeAbstract.contains(member)) {
                    String message = RefactoringBundle.message((String)"0.uses.1.which.is.pushed.down", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)untouchedMember, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
                    conflicts.putValue((Object)untouchedMember, (Object)CommonRefactoringUtil.capitalize((String)message));
                }
            }
        });
    }

    private static boolean checkIncomingReferencesToBaseClassExist(JSClass sourceClass, Collection<JSAttributeListOwner> movedMembers) {
        for (JSAttributeListOwner member : movedMembers) {
            if (member.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC)) continue;
            for (PsiReference ref : ReferencesSearch.search((PsiElement)member, (SearchScope)member.getUseScope(), (boolean)false)) {
                JSReferenceExpression refExpr;
                PsiElement element = ref.getElement();
                if (PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)element, (boolean)true) || !(element instanceof JSReferenceExpression) || (refExpr = (JSReferenceExpression)element).getQualifier() == null) continue;
                String typeString = JSResolveUtil.getQualifiedExpressionType(refExpr.getQualifier(), refExpr.getContainingFile());
                JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
                PsiElement type = resolver.findClassByQName(typeString, refExpr.getResolveScope());
                if (JSInheritanceUtil.isParentClass((JSClass)type, sourceClass)) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkMemberExistsInTargetClass(JSClass sourceClass, JSClass targetClass, JSAttributeListOwner member, MultiMap<PsiElement, String> conflicts) {
        JSFunction overrider;
        if (member instanceof JSField) {
            String name = member.getName();
            JSField field = targetClass.findFieldByName(name);
            if (field != null) {
                String message = RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
                conflicts.putValue((Object)field, (Object)CommonRefactoringUtil.capitalize((String)message));
            }
        } else if (member instanceof JSFunction && !targetClass.isInterface() && (overrider = targetClass.findFunctionByName(member.getName())) != null) {
            String message = RefactoringBundle.message((String)"0.is.already.overridden.in.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false)});
            conflicts.putValue((Object)overrider, (Object)CommonRefactoringUtil.capitalize((String)message));
        }
    }
}

