/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.ASVariableInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableDialog;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducerBase;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceVariableHandler
extends JSBaseIntroduceHandler<JSSourceElement, Settings, JSIntroduceVariableDialog> {
    private static final String LAST_INTRODUCE = "js.last.introduce.type";

    public static Settings.IntroducedVarType getLastIntroduceType(Project project, @Nullable DialectOptionHolder holder) {
        Settings.IntroducedVarType defaultValue = Settings.IntroducedVarType.VAR;
        if (holder != null && holder.hasFeature(JSLanguageFeature.LET_DEFINITIONS)) {
            defaultValue = Settings.IntroducedVarType.LET;
        }
        String value = PropertiesComponent.getInstance((Project)project).getValue(LAST_INTRODUCE, defaultValue.name());
        return Settings.IntroducedVarType.valueOf(value);
    }

    public static void setLastIntroduceType(Project project, Settings.IntroducedVarType value) {
        PropertiesComponent.getInstance((Project)project).setValue(LAST_INTRODUCE, value.name());
    }

    @Override
    protected String getProductivityFeatureId() {
        return "refactoring.introduceVariable";
    }

    @Override
    protected String getRefactoringName() {
        return JSBundle.message((String)"javascript.introduce.variable.title", (Object[])new Object[0]);
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.variable.error.expression.has.void.type";
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.variable.error.no.expression.selected";
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> baseIntroduceContext, JSSourceElement anchor) {
        return this.calcDeclText(baseIntroduceContext, ((Settings)baseIntroduceContext.settings).getIntroducedVarType().toString().toLowerCase(), anchor);
    }

    @Override
    protected JSElement getElementForContextTypeCheck(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> baseIntroduceContext, JSSourceElement anchor) {
        return DialectDetector.isActionScript((PsiElement)anchor) ? super.getElementForContextTypeCheck(baseIntroduceContext, anchor) : anchor;
    }

    @Override
    protected JSBaseInplaceIntroducer<Settings> createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurrences) {
        JSExpression first = (JSExpression)context.expressionDescriptor.first;
        if (first.getParent() instanceof JSExpressionStatement) {
            for (int i = 0; i < occurrences.length; ++i) {
                if (occurrences[i] != first) continue;
                occurrences = (JSExpression[])ArrayUtil.remove((Object[])occurrences, (int)i);
                break;
            }
        }
        return this.createJSorASInplaceIntroducer(context, scope, editor, project, occurrences);
    }

    @NotNull
    protected JSBaseInplaceIntroducer<Settings> createJSorASInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<Settings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurrences) {
        JSVariableInplaceIntroducerBase jSVariableInplaceIntroducerBase = DialectDetector.isActionScript((PsiElement)scope) ? new ASVariableInplaceIntroducer(project, editor, occurrences, this, context) : new JSVariableInplaceIntroducer(project, editor, occurrences, this, context);
        if (jSVariableInplaceIntroducerBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceVariableHandler", "createJSorASInplaceIntroducer"));
        }
        return jSVariableInplaceIntroducerBase;
    }

    @Override
    protected JSIntroduceVariableDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        return new JSIntroduceVariableDialog(project, occurrences, expression, scope);
    }

    @Override
    protected InplaceSettings<Settings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, final PsiElement scope, final OccurrencesChooser.ReplaceChoice choice) {
        BasicIntroducedEntityInfoProvider entityInfoProvider = new BasicIntroducedEntityInfoProvider((JSExpression)expr.first, occurrences, scope);
        final String[] candidateNames = entityInfoProvider.suggestCandidateNames();
        final String myIntroducedName = candidateNames.length > 0 ? candidateNames[0].trim() : "newVar";
        return new InplaceSettings<Settings>(){

            @Override
            public String[] getSuggestedNames() {
                return candidateNames;
            }

            @Override
            public Settings getSettings() {
                return new Settings(){

                    @Override
                    public boolean isReplaceAllOccurrences() {
                        return choice == OccurrencesChooser.ReplaceChoice.ALL;
                    }

                    @Override
                    public String getVariableName() {
                        return myIntroducedName;
                    }

                    @Override
                    public String getVariableType() {
                        return null;
                    }

                    @Override
                    public Settings.IntroducedVarType getIntroducedVarType() {
                        return JSIntroduceVariableHandler.this.getDefaultIntroduceType(scope);
                    }
                };
            }
        };
    }

    protected Settings.IntroducedVarType getDefaultIntroduceType(PsiElement scope) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(scope);
        Settings.IntroducedVarType type = JSIntroduceVariableHandler.getLastIntroduceType(scope.getProject(), holder);
        if (type == Settings.IntroducedVarType.LET && holder != null && !holder.hasFeature(JSLanguageFeature.LET_DEFINITIONS)) {
            return Settings.IntroducedVarType.VAR;
        }
        return type;
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<Settings> introduceContext, Project project, JSLanguageDialect languageDialect, JSSourceElement sourceElement, Editor editor, JSExpression introducedExpression) throws IncorrectOperationException {
        Pair<JSVarStatement, Boolean> preparedDeclarationStatus = super.prepareDeclaration(varDeclText, introduceContext, project, languageDialect, sourceElement, editor, introducedExpression);
        JSVarStatement declaration = (JSVarStatement)preparedDeclarationStatus.first;
        if (sourceElement == introducedExpression.getParent() && sourceElement instanceof JSExpressionStatement && !JSIntroduceVariableHandler.isIntroducingPartOfExpression(introduceContext.expressionDescriptor)) {
            declaration = (JSVarStatement)sourceElement.replace((PsiElement)declaration);
            editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
            return Pair.create((Object)declaration, (Object)Boolean.TRUE);
        }
        return preparedDeclarationStatus;
    }

    @Override
    @Nullable
    protected Pair<JSExpression, TextRange> findIntroducedExpression(PsiFile file, int start, int end, Editor editor, DataContext dataContext) {
        JSSourceElement anchor;
        Pair<JSExpression, TextRange> pair = super.findIntroducedExpression(file, start, end, editor, dataContext);
        if (pair == null) {
            return null;
        }
        JSExpression expression = (JSExpression)pair.first;
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return pair;
        }
        final Ref isContextDependExpression = Ref.create((Object)false);
        expression.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSThisExpression(JSThisExpression node) {
                isContextDependExpression.set((Object)true);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
            }
        });
        if (((Boolean)isContextDependExpression.get()).booleanValue() && (anchor = JSUtils.findSourceAnchor((PsiElement)expression, false)) instanceof JSClass) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor, (String)JSBundle.message((String)"javascript.introduce.incorrect.context", (Object[])new Object[0]), (String)this.getRefactoringName(), null);
            return null;
        }
        return pair;
    }
}

