/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSGetterSetterRenameUtil;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMemberRenameProcessor
extends JSDefaultRenameProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSMemberRenameProcessor", "canProcessElement"));
        }
        if (!super.canProcessElement(element)) {
            return false;
        }
        if (!JSClassUtils.isPossibleHierarchyMember(element)) {
            return false;
        }
        if (DialectDetector.isActionScript(element)) {
            return false;
        }
        return JSUtils.getMemberContainingClass(element) != null;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        Query<JSPsiElementBase> members;
        super.prepareRenaming(element, newName, allRenames, scope);
        if (!JSClassUtils.isPossibleHierarchyMember(element)) {
            return;
        }
        JSAttributeListOwner jsMember = (JSAttributeListOwner)element;
        JSClass jsClass = JSUtils.getMemberContainingClass(element);
        if (!JSInheritanceUtil.canBeSuperMember(jsMember) || jsClass == null) {
            return;
        }
        if (JSClassUtils.isAllowImplementation(jsClass, element)) {
            members = JSMembersSearch.searchImplementingMembers((JSPsiElementBase)jsMember, false);
            members.forEach(el -> JSMemberRenameProcessor.addMemberWithOverload(el, newName, allRenames));
        }
        members = JSMembersSearch.searchOverridingMembers((JSPsiElementBase)jsMember, false);
        members.forEach(el -> JSMemberRenameProcessor.addMemberWithOverload(el, newName, allRenames));
        JSGetterSetterRenameUtil.addGetterSetterRelatedElements(element, jsClass, newName, allRenames);
    }

    private static void addMemberWithOverload(JSPsiElementBase el, String newName, Map<PsiElement, String> allRenames) {
        allRenames.put((PsiElement)el, newName);
        if (el instanceof TypeScriptFunction) {
            for (TypeScriptFunction function : TypeScriptPsiUtil.getAllOverloads((TypeScriptFunction)el)) {
                allRenames.put((PsiElement)function, newName);
            }
        }
    }

    @Override
    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSMemberRenameProcessor", "substituteElementToRename"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/refactoring/JSMemberRenameProcessor", "substituteElementToRename"));
        }
        if (renameCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renameCallback", "com/intellij/lang/javascript/refactoring/JSMemberRenameProcessor", "substituteElementToRename"));
        }
        Pair<JSPsiElementBase, JSClass> memberJSClassPair = JSMemberRenameProcessor.getSuperMember(element);
        if (memberJSClassPair == null) {
            this.processSubstituted(element, editor, renameCallback);
            return;
        }
        JSPsiElementBase parentMember = (JSPsiElementBase)memberJSClassPair.first;
        JSPsiElementBase currentMember = (JSPsiElementBase)element;
        String title = JSMemberRenameProcessor.getMemberTitle(parentMember);
        this.substituteWithPopup(editor, renameCallback, JSMemberRenameProcessor.getDialogTitle(parentMember, (JSClass)memberJSClassPair.second), null, (PsiElement)parentMember, "Rename base " + title, (PsiElement)currentMember, "Rename current " + title);
    }

    @Override
    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        Pair<JSPsiElementBase, JSClass> memberJSClassPair = JSMemberRenameProcessor.getSuperMember(element);
        if (memberJSClassPair == null) {
            return super.substituteElementToRename(element, editor);
        }
        JSPsiElementBase parentMember = (JSPsiElementBase)memberJSClassPair.first;
        JSClass parentClass = (JSClass)memberJSClassPair.second;
        String memberTitle = JSMemberRenameProcessor.getMemberTitle(parentMember);
        return this.substituteWithPopup(editor, null, JSMemberRenameProcessor.getDialogTitle(parentMember, parentClass), IdeBundle.message((String)"prompt.do.you.want.to.action_verb.the.method.from_class", (Object[])new Object[]{"rename", 1}), (PsiElement)parentMember, "Rename base " + memberTitle, element, "Rename current " + memberTitle);
    }

    @Nullable
    private static Pair<JSPsiElementBase, JSClass> getSuperMember(PsiElement element) {
        if (!JSClassUtils.isPossibleHierarchyMember(element)) {
            return null;
        }
        JSAttributeListOwner jsMember = (JSAttributeListOwner)element;
        JSClass jsClass = JSUtils.getMemberContainingClass(element);
        if (!JSInheritanceUtil.canHaveSuperMember(jsMember) || jsClass == null) {
            return null;
        }
        Collection<JSPsiElementBase> members = JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)jsMember);
        if (members.size() > 1) {
            return null;
        }
        JSPsiElementBase parentMember = (JSPsiElementBase)ContainerUtil.getFirstItem(members);
        JSClass parentClass = JSUtils.getMemberContainingClass((PsiElement)parentMember);
        if (parentMember == null || parentClass == null) {
            return null;
        }
        return Pair.create((Object)parentMember, (Object)parentClass);
    }

    @NotNull
    private static String getDialogTitle(JSPsiElementBase parentMember, JSClass parentClass) {
        String memberName = JSMemberRenameProcessor.getMemberTitle(parentMember);
        String string = parentMember.getName() + (parentClass.isInterface() ? " implements" : " overrides") + " " + memberName + " of " + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)parentClass);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSMemberRenameProcessor", "getDialogTitle"));
        }
        return string;
    }

    @NotNull
    private static String getMemberTitle(JSPsiElementBase parentMember) {
        String string = parentMember instanceof JSField ? "field" : "method";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSMemberRenameProcessor", "getMemberTitle"));
        }
        return string;
    }
}

