/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FormatFixer {
    private static final Logger LOG = Logger.getInstance((String)FormatFixer.class.getName());
    private final RangeMarker myRangeMarker;
    private final PsiFile myFile;
    private final Document myDocument;
    private boolean myIsReformat;

    public static FormatFixer create(PsiFile file, TextRange possibleRange, Mode mode) {
        return FormatFixer.create(file, possibleRange, PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file), mode);
    }

    public static FormatFixer create(PsiFile file, TextRange possibleRange, Document document, Mode mode) {
        if (!file.isValid()) {
            String detail;
            try {
                detail = " with text: '" + possibleRange.substring(file.getText()) + "'";
            }
            catch (StringIndexOutOfBoundsException e) {
                detail = " with invalid range: " + possibleRange;
            }
            LOG.error("invalid file: " + file.getName() + detail);
        }
        int reformatRangeStart = possibleRange.getStartOffset();
        int reformatRangeEnd = possibleRange.getEndOffset();
        CharSequence text = document.getCharsSequence();
        if (mode == Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact) {
            reformatRangeStart = document.getLineStartOffset(document.getLineNumber(reformatRangeStart));
            reformatRangeEnd = document.getLineEndOffset(document.getLineNumber(reformatRangeEnd - 1));
            reformatRangeEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)reformatRangeEnd, (String)" \t\n");
        } else if (mode == Mode.FirstLinebreak) {
            if (reformatRangeStart > 0) {
                reformatRangeStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(reformatRangeStart - 1), (String)" \t") + 1;
            }
            if ((reformatRangeEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)reformatRangeEnd, (String)" \t")) < text.length() - 1 && text.charAt(reformatRangeEnd) == '\n') {
                ++reformatRangeEnd;
            }
        } else if (mode == Mode.Reformat) {
            if (reformatRangeStart > 0) {
                reformatRangeStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(reformatRangeStart - 1), (String)" \t\n") + 1;
            }
            reformatRangeEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)reformatRangeEnd, (String)" \t\n");
        } else if (mode == Mode.FollowingWhitespace) {
            if (reformatRangeStart > 0) {
                reformatRangeStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(reformatRangeStart - 1), (String)" \t") + 1;
            }
            reformatRangeEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)reformatRangeEnd, (String)" \t\n");
        } else {
            LOG.error(String.valueOf((Object)mode));
        }
        return new FormatFixer(mode == Mode.Reformat, file, document, reformatRangeStart, reformatRangeEnd);
    }

    private FormatFixer(boolean isReformat, PsiFile file, Document document, int reformatRangeStart, int reformatRangeEnd) {
        this.myIsReformat = isReformat;
        PsiElement context = file.getContext();
        if (context != null) {
            TextRange range = InjectedLanguageManager.getInstance((Project)file.getProject()).injectedToHost((PsiElement)file, new TextRange(reformatRangeStart, reformatRangeEnd));
            file = context.getContainingFile();
            document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            reformatRangeStart = range.getStartOffset();
            reformatRangeEnd = range.getEndOffset();
        }
        this.myRangeMarker = document.createRangeMarker(reformatRangeStart, reformatRangeEnd);
        this.myDocument = document;
        FileViewProvider viewProvider = file.getViewProvider();
        this.myFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    public static FormatFixer create(PsiElement from, PsiElement to, Mode mode) {
        PsiFile file = from.getContainingFile();
        LOG.assertTrue(file == to.getContainingFile());
        return FormatFixer.create(file, from.getTextRange().union(to.getTextRange()), mode);
    }

    public static FormatFixer create(PsiElement element, Mode mode) {
        return FormatFixer.create(element, element, mode);
    }

    public void fixFormat() {
        int changeEnd;
        Project project = this.myFile.getProject();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(this.myDocument);
        if (!this.myRangeMarker.isValid()) {
            return;
        }
        int changeStart = this.myRangeMarker.getStartOffset();
        if (changeStart >= (changeEnd = Math.min(this.myRangeMarker.getEndOffset(), this.myDocument.getTextLength()))) {
            return;
        }
        if (this.myIsReformat) {
            changeEnd = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)changeEnd, (String)" \t\n");
            CodeStyleManager.getInstance((Project)project).reformatText(this.myFile, changeStart, changeEnd);
        } else {
            int start;
            int n = start = changeStart > 0 ? CharArrayUtil.shiftBackward((CharSequence)this.myDocument.getCharsSequence(), (int)(changeStart - 1), (String)" \t\n") + 1 : changeStart;
            if (start < changeStart && this.myDocument.getCharsSequence().charAt(start) == '\n') {
                ++start;
            }
            int end = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)changeEnd, (String)" \t\n");
            RangeMarker widerRange = this.myDocument.createRangeMarker(start, end);
            int newlinesBeforeRange = StringUtil.countNewLines((CharSequence)this.myDocument.getCharsSequence().subSequence(start, changeStart));
            int newlinesAfterRange = StringUtil.countNewLines((CharSequence)this.myDocument.getCharsSequence().subSequence(changeEnd, end));
            FormatFixer.doReformat(this.myFile, changeStart, changeEnd);
            RangeMarker rangeMarker = this.myRangeMarker;
            if (!rangeMarker.isValid()) {
                rangeMarker = widerRange;
            }
            if ((newlinesBeforeRange > 0 || newlinesAfterRange > 0) && rangeMarker.isValid()) {
                if (newlinesBeforeRange > 0) {
                    this.myDocument.insertString(rangeMarker.getStartOffset(), (CharSequence)StringUtil.repeatSymbol((char)'\n', (int)newlinesBeforeRange));
                }
                if (newlinesAfterRange > 0) {
                    boolean afterAsBefore = FormatFixer.isTabsAndSpaces(this.myDocument.getText().substring(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
                    this.myDocument.insertString(afterAsBefore ? rangeMarker.getStartOffset() : rangeMarker.getEndOffset(), (CharSequence)StringUtil.repeatSymbol((char)'\n', (int)newlinesAfterRange));
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
            }
        }
    }

    private static boolean isTabsAndSpaces(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ' || s.charAt(i) == '\t') continue;
            return false;
        }
        return true;
    }

    public static List<FormatFixer> merge(List<FormatFixer> formatters) {
        MultiMap byFiles = MultiMap.create();
        for (FormatFixer formatter : formatters) {
            byFiles.putValue((Object)formatter.myFile, (Object)formatter);
        }
        ArrayList<FormatFixer> result = new ArrayList<FormatFixer>();
        for (PsiFile file : byFiles.keySet()) {
            result.addAll(FormatFixer.mergeSingleFile((List)byFiles.get((Object)file)));
        }
        return result;
    }

    public static List<FormatFixer> mergeSingleFile(List<FormatFixer> formatters) {
        if (formatters.size() < 2) {
            return formatters;
        }
        PsiFile file = formatters.iterator().next().myFile;
        Document document = formatters.iterator().next().myDocument;
        HashMap<TextRange, FormatFixer> fixWhitespace = new HashMap<TextRange, FormatFixer>();
        HashMap<TextRange, FormatFixer> reformats = new HashMap<TextRange, FormatFixer>();
        for (FormatFixer f : formatters) {
            if (!f.myRangeMarker.isValid()) continue;
            LOG.assertTrue(file == f.myFile);
            LOG.assertTrue(document == f.myDocument);
            if (f.myIsReformat) {
                FormatFixer.addRange(reformats, f);
                continue;
            }
            FormatFixer.addRange(fixWhitespace, f);
        }
        HashMap<TextRange, FormatFixer> reformatsUnited = new HashMap<TextRange, FormatFixer>();
        Iterator i = reformats.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (!FormatFixer.unionIfIntersects(reformatsUnited, (FormatFixer)e.getValue())) continue;
            i.remove();
        }
        reformatsUnited.putAll(reformats);
        ArrayList<FormatFixer> result = new ArrayList<FormatFixer>();
        result.addAll(fixWhitespace.values());
        result.addAll(reformatsUnited.values());
        return result;
    }

    private static void addRange(Map<TextRange, FormatFixer> ranges, FormatFixer f) {
        TextRange toAdd = TextRange.create((Segment)f.myRangeMarker);
        ArrayList<TextRange> toRemove = new ArrayList<TextRange>();
        for (TextRange existing : ranges.keySet()) {
            if (existing.contains(toAdd)) {
                return;
            }
            if (toAdd.contains(existing)) {
                toRemove.add(existing);
            }
            if (!existing.intersects(toAdd)) continue;
            toRemove.add(existing);
            toAdd = existing.union(toAdd);
        }
        ranges.keySet().removeAll(toRemove);
        ranges.put(toAdd, new FormatFixer(f.myIsReformat, f.myFile, f.myDocument, toAdd.getStartOffset(), toAdd.getEndOffset()));
    }

    private static boolean unionIfIntersects(Map<TextRange, FormatFixer> ranges, FormatFixer f) {
        if (ranges.isEmpty()) {
            return false;
        }
        boolean isReformat = ranges.values().iterator().next().myIsReformat;
        TextRange toAdd = TextRange.create((Segment)f.myRangeMarker);
        ArrayList<TextRange> toRemove = new ArrayList<TextRange>();
        boolean intersects = false;
        for (TextRange existing : ranges.keySet()) {
            if (existing.contains(toAdd)) {
                return true;
            }
            if (!existing.intersects(toAdd)) continue;
            toRemove.add(existing);
            toAdd = existing.union(toAdd);
            intersects = true;
        }
        if (intersects) {
            ranges.keySet().removeAll(toRemove);
            ranges.put(toAdd, new FormatFixer(isReformat, f.myFile, f.myDocument, toAdd.getStartOffset(), toAdd.getEndOffset()));
        }
        return intersects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doReformat(PsiFile file, int startOffset, int endOffset) {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)file.getProject());
        CodeStyleSettings currentSettings = CodeStyleSettingsManager.getSettings((Project)file.getProject());
        CommonCodeStyleSettings langSettings = currentSettings.getCommonSettings(JSLanguageUtil.getLanguageDialect((PsiElement)file, startOffset));
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)currentSettings.getCustomSettings(XmlCodeStyleSettings.class);
        int blankLinesInCode = langSettings.KEEP_BLANK_LINES_IN_CODE;
        int blankLinesAroundMethod = langSettings.BLANK_LINES_AROUND_METHOD;
        int blankLinesBeforeImports = langSettings.BLANK_LINES_BEFORE_IMPORTS;
        int blankLinesAfterImports = langSettings.BLANK_LINES_AFTER_IMPORTS;
        int xmlBlankLines = xmlSettings.XML_KEEP_BLANK_LINES;
        boolean xmlKeepWhiteSpacesInsideCdata = xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA;
        try {
            langSettings.KEEP_BLANK_LINES_IN_CODE = 0;
            langSettings.BLANK_LINES_AROUND_METHOD = 0;
            langSettings.BLANK_LINES_BEFORE_IMPORTS = 0;
            langSettings.BLANK_LINES_AFTER_IMPORTS = 0;
            xmlSettings.XML_KEEP_BLANK_LINES = 0;
            xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA = false;
            codeStyleManager.reformatText(file, startOffset, endOffset);
        }
        finally {
            langSettings.KEEP_BLANK_LINES_IN_CODE = blankLinesInCode;
            langSettings.BLANK_LINES_AROUND_METHOD = blankLinesAroundMethod;
            langSettings.BLANK_LINES_BEFORE_IMPORTS = blankLinesBeforeImports;
            langSettings.BLANK_LINES_AFTER_IMPORTS = blankLinesAfterImports;
            xmlSettings.XML_KEEP_BLANK_LINES = xmlBlankLines;
            xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA = xmlKeepWhiteSpacesInsideCdata;
        }
    }

    public static void fixAll(List<FormatFixer> inlinedPlacesFormatFixers) {
        for (FormatFixer formatter : inlinedPlacesFormatFixers) {
            formatter.fixFormat();
        }
    }

    public static enum Mode {
        FirstLinebreak,
        Reformat,
        FollowingWhitespace,
        InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact;

    }
}

