/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPsiTreeUtil {
    @Nullable
    public static PsiElement getChildExcludingTypes(@NotNull PsiElement element, Class<?> ... classes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSPsiTreeUtil", "getChildExcludingTypes"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/lang/javascript/psi/util/JSPsiTreeUtil", "getChildExcludingTypes"));
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            boolean filtered = false;
            for (Class<?> aClass : classes) {
                if (!aClass.isInstance(child)) continue;
                filtered = true;
                break;
            }
            if (filtered) continue;
            return child;
        }
        return null;
    }

    public static boolean isLineBreakWhiteSpace(PsiElement element) {
        return element instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)element.getText());
    }
}

