/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSProjectUtil {
    public static final ModificationTracker FILE_SYSTEM_STRUCTURE_MODIFICATION_TRACKER = new ModificationTracker(){

        public long getModificationCount() {
            return ManagingFS.getInstance().getStructureModificationCount();
        }
    };

    public static boolean isInLibrary(PsiElement element) {
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class, (boolean)false);
        if (jsClass != null && JSResolveUtil.isObjectClass(jsClass)) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        if (file.getContext() != null) {
            file = file.getContext().getContainingFile();
        }
        if (file == null) {
            return false;
        }
        VirtualFile vFile = file.getOriginalFile().getVirtualFile();
        if (vFile == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        return index.isInLibrarySource(vFile) || index.isInLibraryClasses(vFile);
    }

    @Nullable
    public static ScriptingFrameworkDescriptor detectFramework(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/psi/util/JSProjectUtil", "detectFramework"));
        }
        String baseKey = JSDocumentationUtils.getBaseKey(url);
        if (baseKey == null) {
            return null;
        }
        String name = JSExternalLibraryDocBundle.getLibraryName(baseKey);
        if (name == null) {
            return null;
        }
        String versionMatcher = JSExternalLibraryDocBundle.getVersionMatcher(baseKey);
        String version = null;
        if (versionMatcher != null && url.matches("^.*(" + versionMatcher + ").*$")) {
            version = url.replaceFirst("^.*(" + versionMatcher + ").*$", "$1");
        }
        return new ScriptingFrameworkDescriptor(name, version);
    }
}

