/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompositeFunctionPropertySignatureImpl
implements JSRecordType.PropertySignature {
    private final boolean myIsOptional;
    @NotNull
    private final String myName;
    @NotNull
    private final List<JSRecordType.PropertySignature> myFunctionSignatures;
    @NotNull
    private final JSTypeSource myTypeSource;
    @NotNull
    private final NotNullLazyValue<JSType> myType;

    public JSCompositeFunctionPropertySignatureImpl(@NotNull String name, @NotNull List<JSRecordType.PropertySignature> functionSignatures, boolean isOptional, @NotNull JSTypeSource typeSource) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl", "<init>"));
        }
        if (functionSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionSignatures", "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl", "<init>"));
        }
        if (typeSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSource", "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl", "<init>"));
        }
        this.myType = NotNullLazyValue.createValue(() -> {
            List<JSRecordType.PropertySignature> members = this.getMembers();
            ArrayList toMerge = ContainerUtil.newArrayListWithCapacity((int)members.size());
            for (JSRecordType.PropertySignature signature : members) {
                JSType type = signature.getType();
                if (!(type instanceof JSFunctionTypeImpl)) continue;
                toMerge.add(new JSRecordTypeImpl.CallSignatureImpl(false, (JSFunctionTypeImpl)type));
            }
            return new JSRecordTypeImpl(this.getTypeSource(), toMerge);
        });
        this.myName = name;
        this.myIsOptional = isOptional;
        this.myFunctionSignatures = functionSignatures;
        this.myTypeSource = typeSource;
    }

    public final boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, boolean allowResolve) {
        if (this.isFastEquivalentTo(other)) {
            return true;
        }
        return JSRecordType.arePropertySignaturesEqual((JSRecordType.PropertySignature)this, (JSRecordType.TypeMember)other, (boolean)allowResolve);
    }

    final boolean isFastEquivalentTo(@Nullable JSRecordType.TypeMember other) {
        if (!(other instanceof JSCompositeFunctionPropertySignatureImpl)) {
            return false;
        }
        JSCompositeFunctionPropertySignatureImpl otherFPSignature = (JSCompositeFunctionPropertySignatureImpl)other;
        List<JSRecordType.PropertySignature> members = this.getMembers();
        List<JSRecordType.PropertySignature> otherMembers = otherFPSignature.getMembers();
        return ContainerUtil.equalsIdentity(members, otherMembers);
    }

    @Nullable
    public PsiElement getSource() {
        return null;
    }

    @NotNull
    public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSource) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl", "copyTypeHierarchy"));
        }
        List<JSRecordType.PropertySignature> members = this.getMembers();
        ArrayList resultMembers = ContainerUtil.newArrayListWithCapacity((int)members.size());
        for (JSRecordType.PropertySignature propertySignature : members) {
            resultMembers.add(propertySignature.copyTypeHierarchy(childTransform, shouldCleanSource));
        }
        JSCompositeFunctionPropertySignatureImpl jSCompositeFunctionPropertySignatureImpl = new JSCompositeFunctionPropertySignatureImpl(this.getMemberName(), resultMembers, this.isOptional(), shouldCleanSource ? JSTypeSource.EMPTY : this.getTypeSource());
        if (jSCompositeFunctionPropertySignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl", "copyTypeHierarchy"));
        }
        return jSCompositeFunctionPropertySignatureImpl;
    }

    @NotNull
    public String getMemberName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl", "getMemberName"));
        }
        return string;
    }

    public boolean isOptional() {
        return this.myIsOptional;
    }

    public List<JSRecordType.PropertySignature> getMembers() {
        return this.myFunctionSignatures;
    }

    public JSCompositeFunctionPropertySignatureImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl", "copyWithNewSource"));
        }
        return new JSCompositeFunctionPropertySignatureImpl(this.getMemberName(), this.getMembers(), this.isOptional(), source);
    }

    @NotNull
    public JSTypeSource getTypeSource() {
        JSTypeSource jSTypeSource = this.myTypeSource;
        if (jSTypeSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl", "getTypeSource"));
        }
        return jSTypeSource;
    }

    public JSType getType() {
        return (JSType)this.myType.getValue();
    }
}

