/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubTreeUtil {
    @Nullable
    public static StubElement getNextSibling(StubElement<?> stub) {
        return StubTreeUtil.getNextSibling(stub, null);
    }

    @Nullable
    public static StubElement getNextSibling(StubElement<?> stub, @Nullable TokenSet filter) {
        StubElement parentStub = stub.getParentStub();
        List children = parentStub.getChildrenStubs();
        boolean stubFound = false;
        for (StubElement child : children) {
            if (stubFound && (filter == null || filter.contains((IElementType)child.getStubType()))) {
                return child;
            }
            if (stub != child) continue;
            stubFound = true;
        }
        return null;
    }

    @Nullable
    public static StubElement getPrevSibling(StubElement<?> stub) {
        StubElement parentStub = stub.getParentStub();
        List children = parentStub.getChildrenStubs();
        StubElement prevSibling = null;
        for (StubElement child : children) {
            if (stub == child) {
                return prevSibling;
            }
            prevSibling = child;
        }
        return null;
    }

    @Nullable
    public static Language getJSLanguage(@NotNull StubElement<?> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "getJSLanguage"));
        }
        for (StubElement parent = stub; parent != null; parent = parent.getParentStub()) {
            stub = parent;
        }
        return stub instanceof JSFileStubImpl ? ((JSFileStubImpl)stub).getLanguage() : null;
    }

    @Nullable
    public static StubElement findChildStubByType(@NotNull StubElement<?> parent, @NotNull TokenSet types) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "findChildStubByType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "findChildStubByType"));
        }
        List children = parent.getChildrenStubs();
        for (StubElement child : children) {
            if (!types.contains((IElementType)child.getStubType())) continue;
            return child;
        }
        return null;
    }

    public static boolean isFromGlobalNamespace(StubElement startElement) {
        for (StubElement parentStub = startElement.getParentStub(); parentStub != null; parentStub = parentStub.getParentStub()) {
            StubElement possibleFileElement;
            if (parentStub instanceof PsiFileStub) {
                if (parentStub instanceof JSFileStubImpl) {
                    JSFileStubImpl fileStub = (JSFileStubImpl)parentStub;
                    JSFileCachedData data = fileStub.getCachedData();
                    return data == null || !data.isCommonJSModule();
                }
                return true;
            }
            if (!(parentStub instanceof TypeScriptModuleStub) || !((possibleFileElement = parentStub.getParentStub()) instanceof JSFileStubImpl)) continue;
            String name = ((TypeScriptModuleStub)parentStub).getName();
            return name == null || !StringUtil.isQuotedString((String)name);
        }
        return true;
    }

    public static boolean checkParentStubShouldCreate(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil", "checkParentStubShouldCreate"));
        }
        ASTNode owner = node.getTreeParent();
        if (owner != null) {
            IElementType ownerType = owner.getElementType();
            if (ownerType instanceof IStubElementType) {
                return ((IStubElementType)ownerType).shouldCreateStub(owner);
            }
            if (ownerType instanceof JSFileElementType) {
                return true;
            }
        }
        return false;
    }
}

