/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSDefinitionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefinitionExpressionStubImpl
extends JSQualifiedObjectStubBase<JSDefinitionExpression>
implements JSDefinitionExpressionStub {
    private static final BooleanStructureElement TYPE_EXPLICITLY_DECLARED = new BooleanStructureElement();
    private static final BooleanStructureElement IS_DECLARATION = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INDEXING_DATA_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INITIALIZER_REFERENCE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement KEEPS_INITIALIZER_STUB_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSQualifiedObjectStubBase.FLAGS_STRUCTURE, TYPE_EXPLICITLY_DECLARED, IS_DECLARATION, HAS_TYPE_FLAG, HAS_INDEXING_DATA_FLAG, HAS_INITIALIZER_REFERENCE_FLAG, KEEPS_INITIALIZER_STUB_FLAG);
    @Nullable
    private final StringRef myTypeString;
    @Nullable
    private final JSElementIndexingDataStructure myIndexingDataStructure;
    @Nullable
    private final StringRef myInitializerReference;

    public JSDefinitionExpressionStubImpl(JSDefinitionExpression clazz, StubElement parent) {
        super(clazz, parent, JSStubElementTypes.DEFINITION_EXPRESSION);
        JSType type = clazz.getType();
        this.myTypeString = type != null ? StringRef.fromString((String)type.getTypeText(JSType.TypeTextFormat.SERIALIZED)) : null;
        this.writeFlag(TYPE_EXPLICITLY_DECLARED, type != null && type.getSource().isExplicitlyDeclared());
        JSElementIndexingData indexingData = clazz.getIndexingData();
        this.myIndexingDataStructure = indexingData != null && !indexingData.isEmpty() ? indexingData.toStructure() : null;
        this.myInitializerReference = StringRef.fromString((String)clazz.getInitializerReference());
        this.writeFlag(IS_DECLARATION, clazz.isDeclaration());
        this.writeFlag(HAS_TYPE_FLAG, this.myTypeString != null);
        this.writeFlag(HAS_INDEXING_DATA_FLAG, this.myIndexingDataStructure != null);
        this.writeFlag(HAS_INITIALIZER_REFERENCE_FLAG, this.myInitializerReference != null);
        this.writeFlag(KEEPS_INITIALIZER_STUB_FLAG, JSStubIndexingUtils.keepsInitializerStub((JSInitializerOwner)clazz));
    }

    public JSDefinitionExpressionStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (IStubElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
        this.myTypeString = this.readFlag(HAS_TYPE_FLAG) != false ? dataStream.readName() : null;
        this.myIndexingDataStructure = this.readFlag(HAS_INDEXING_DATA_FLAG) != false ? JSElementIndexingDataStructureImpl.deserialize(dataStream) : null;
        this.myInitializerReference = this.readFlag(HAS_INITIALIZER_REFERENCE_FLAG) != false ? dataStream.readName() : null;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_TYPE_FLAG).booleanValue()) {
            JSDefinitionExpressionStubImpl.writeString(this.myTypeString, dataStream);
        }
        if (this.readFlag(HAS_INDEXING_DATA_FLAG).booleanValue()) {
            JSElementIndexingDataStructureImpl.serialize(this.myIndexingDataStructure, dataStream);
        }
        if (this.readFlag(HAS_INITIALIZER_REFERENCE_FLAG).booleanValue()) {
            JSDefinitionExpressionStubImpl.writeString(this.myInitializerReference, dataStream);
        }
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        JSElementIndexingDataStructureImpl.index(this.myIndexingDataStructure, sink);
    }

    public JSDefinitionExpression createPsi() {
        return new JSDefinitionExpressionImpl(this);
    }

    @Nullable
    public String getTypeString() {
        return this.myTypeString != null ? this.myTypeString.getString() : null;
    }

    public boolean isTypeExplicitlyDeclared() {
        return this.readFlag(TYPE_EXPLICITLY_DECLARED);
    }

    @Nullable
    public JSElementIndexingDataStructure getIndexingDataStructure() {
        return this.myIndexingDataStructure;
    }

    @Nullable
    public String getInitializerReference() {
        return this.myInitializerReference != null ? this.myInitializerReference.getString() : null;
    }

    public boolean isDeclaration() {
        return this.readFlag(IS_DECLARATION);
    }

    public boolean keepsInitializerStub() {
        return this.readFlag(KEEPS_INITIALIZER_STUB_FLAG);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSDefinitionExpressionStubImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }
}

