/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSHierarchyProcessor;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessorBase;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WalkUpResolveProcessor
extends BaseJSSymbolProcessor {
    private List<JSTaggedResolveResult> matchData;
    private int myBestMatchedLevel;
    protected boolean myAllowPartialResults;
    private boolean myCanHaveValidPartialMatches;
    private boolean mySkipDefs;
    protected boolean myNewPropertiesDefinitionAllowed;
    private boolean myQualifierReferencesModule;
    protected final String myName;

    public WalkUpResolveProcessor(@NotNull String name, @NotNull PsiFile targetFile, @NotNull PsiElement context, @NotNull BaseJSSymbolProcessor.MatchMode _matchMode) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "<init>"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "<init>"));
        }
        if (_matchMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_matchMode", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "<init>"));
        }
        super(targetFile, context, _matchMode);
        this.myBestMatchedLevel = -1;
        this.myAllowPartialResults = false;
        this.myCanHaveValidPartialMatches = true;
        this.myName = name;
        if (context instanceof JSReferenceExpression) {
            JSNamespaceEvaluationResult ns;
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            JSExpression originalQualifier = refExpr.getQualifier();
            JSExpression qualifier = JSResolveUtil.getRealRefExprQualifier(refExpr);
            JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class);
            boolean haveNotEncounteredDynamics = true;
            if (qualifier == null || originalQualifier == null) {
                if (qualifier == null) {
                    JSImportedElementResolveResult expression = JSImportHandlingUtil.resolveTypeNameUsingImports(refExpr);
                    if (expression != null) {
                        JSQualifiedName qName = JSResolveUtil.buildNamespaceForQualifier(JSResolveUtil.getRealRefExprQualifierFromResult(refExpr, expression)).getQualifiedName();
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(qName != null ? qName.getQualifiedName() : "");
                    } else if (this.typescript) {
                        TypeScriptModule module = (TypeScriptModule)PsiTreeUtil.getParentOfType((PsiElement)refExpr, TypeScriptModule.class);
                        if (module != null) {
                            String qualifiedName = module.getQualifiedName();
                            assert (qualifiedName != null);
                            this.myTypeInfo.addAllParentScopes(qualifiedName);
                        }
                    } else if (this.ecmal4) {
                        this.addPackageScope(jsClass, (PsiElement)refExpr);
                    } else {
                        JSTypeEvaluateManager.iterateTypeHierarchy("Window", this.createHierarchyProcessor(), this.myContext);
                    }
                } else {
                    assert (originalQualifier == null);
                    if (refExpr.isAttributeReference()) {
                        haveNotEncounteredDynamics = false;
                    }
                }
            } else {
                if ((qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) && qualifier instanceof JSThisExpression) {
                    PsiElement clazz;
                    String contextQualifierText;
                    boolean explicitlyDeclared;
                    ns = JSContextResolver.resolveContext((PsiElement)qualifier);
                    boolean bl = explicitlyDeclared = ns != null && ns.isExplicitlyDeclared();
                    if (explicitlyDeclared) {
                        this.setAddOnlyCompleteMatches(true);
                    }
                    Object object = (contextQualifierText = JSNamespaceEvaluationResult.getQualifiedName(ns)) == null ? null : (clazz = this.ecmal4 ? JSClassResolver.findClassFromNamespace(contextQualifierText, context) : TypeScriptClassResolver.getInstance().findAnyClassByQName(contextQualifierText, JSResolveUtil.getResolveScope(context)));
                    if (clazz instanceof JSClass) {
                        boolean clazzIsDynamic;
                        JSAttributeList attrList = ((JSClass)clazz).getAttributeList();
                        if (attrList != null && (clazzIsDynamic = attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC))) {
                            haveNotEncounteredDynamics = false;
                        }
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(contextQualifierText);
                    } else if (contextQualifierText != null) {
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(contextQualifierText, true, ns.getJSContext());
                    }
                    if (!explicitlyDeclared) {
                        this.myTypeInfo.setForcedUnknownContext();
                    }
                }
                if (!(qualifier instanceof JSThisExpression) && !(qualifier instanceof JSSuperExpression) || !this.ecmal4) {
                    JSTypeEvaluator.evaluateTypes(qualifier, this.myTargetFile, this.createTypeProcessor((PsiElement)qualifier));
                }
            }
            if (!this.myTypeInfo.isEmpty()) {
                if (!this.myAddOnlyCompleteMatchesSet) {
                    this.myAddOnlyCompleteMatches = haveNotEncounteredDynamics;
                    this.myCanHaveValidPartialMatches = !this.ecmal4 && !this.typescript && !this.myTypeInfo.isGlobalStatusHint() || !haveNotEncounteredDynamics;
                }
            } else {
                if (qualifier instanceof JSReferenceExpression && (ns = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)qualifier, JSContext.STATIC, true)) != null) {
                    this.myTypeInfo.addNamespace(ns, false);
                }
                if ((this.ecmal4 || this.typescript) && _matchMode == BaseJSSymbolProcessor.MatchMode.Strict) {
                    this.myAddOnlyCompleteMatches = true;
                    this.myCanHaveValidPartialMatches = false;
                }
            }
        } else if (context instanceof JSDestructuringProperty) {
            PsiElement parent = context.getParent();
            JSTypeEvaluator.evaluateExpressionOrElementTypes(this.myTargetFile, this.createTypeProcessor(parent), parent, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        }
        if (this.myTypeInfo.hasExplicitNamespace()) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.initCheckFileLevelAccess();
    }

    @NotNull
    private JSHierarchyProcessor createHierarchyProcessor() {
        JSHierarchyProcessor jSHierarchyProcessor = new JSHierarchyProcessor(){

            @Override
            public boolean processNamespace(String qName, VirtualFile file) {
                return true;
            }

            @Override
            public boolean processClass(JSClass clazz) {
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                return WalkUpResolveProcessor.this.processObjectLiteral(objectLiteral);
            }
        };
        if (jSHierarchyProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "createHierarchyProcessor"));
        }
        return jSHierarchyProcessor;
    }

    @Override
    protected boolean isStrictTypingPossible(PsiElement source, @NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "isStrictTypingPossible"));
        }
        return (type.getSource().getLanguage() != JSTypeSource.SourceLanguage.JS || type.getSource().isExplicitlyDeclared()) && super.isStrictTypingPossible(source, type);
    }

    @NotNull
    private JSTypeProcessor createTypeProcessor(PsiElement qualifier) {
        JSTypeProcessorBase jSTypeProcessorBase = this.ecmal4 ? new ActionScriptResolveTypeProcessor() : new JSResolveTypeProcessor(qualifier);
        if (jSTypeProcessorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "createTypeProcessor"));
        }
        return jSTypeProcessorBase;
    }

    @Override
    @NotNull
    protected JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context, @Nullable PsiElement contextRefQualifier) {
        JSElement container;
        JSTypeInfo.GlobalStatusHint statusHint = super.initGlobalStatusHint(context, contextRefQualifier);
        if (context instanceof JSReferenceExpression && (container = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSEmbeddedContent.class, JSFile.class})) != null && (container.getContainingFile().getContext() != null || container.getContext() instanceof XmlAttributeValue) && statusHint == JSTypeInfo.GlobalStatusHint.GLOBAL) {
            statusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
        }
        JSTypeInfo.GlobalStatusHint globalStatusHint = statusHint;
        if (globalStatusHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "initGlobalStatusHint"));
        }
        return globalStatusHint;
    }

    public void addTypeHierarchy(@NotNull String typeString, final @NotNull JSContext staticOrInstance, final boolean isExplicitlyDeclared, @Nullable PsiFile jsModule) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "addTypeHierarchy"));
        }
        if (staticOrInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticOrInstance", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "addTypeHierarchy"));
        }
        JSHierarchyProcessor processor = new JSHierarchyProcessor(){

            @Override
            public boolean processNamespace(String serializedType, VirtualFile file) {
                JSNamespace namespace;
                JSType type = JSTypeUtils.createType(serializedType, JSTypeSource.EMPTY);
                if (type != null && (namespace = JSTypeUtils.getNamespaceMatchingType(type, false, isExplicitlyDeclared)) != null) {
                    WalkUpResolveProcessor.this.myTypeInfo.addNamespace(namespace, false);
                }
                return true;
            }

            @Override
            public boolean processClass(JSClass clazz) {
                String name = clazz.getQualifiedName();
                if (name != null) {
                    WalkUpResolveProcessor.this.myTypeInfo.addNamespace(name, false, staticOrInstance, isExplicitlyDeclared);
                }
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                return WalkUpResolveProcessor.this.processObjectLiteral(objectLiteral);
            }
        };
        this.myTypeInfo.addNamespace(typeString, true, staticOrInstance, isExplicitlyDeclared, jsModule);
        if (staticOrInstance == JSContext.STATIC) {
            typeString = JSNamedType.appendStaticSuffix(typeString);
        }
        JSTypeEvaluateManager.iterateTypeHierarchy(typeString, processor, this.myContext);
    }

    protected void doUnqualifiedCheck(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "doUnqualifiedCheck"));
        }
        this.addPartialResult(element, null);
    }

    protected void doQualifiedCheck(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "doQualifiedCheck"));
        }
        String isAcceptable = this.isAcceptable(element);
        if (isAcceptable != null) {
            this.addCompleteResultWithProblem((PsiElement)element, isAcceptable);
            return;
        }
        JSQualifiedName namespace = element.getNamespace();
        Ref matchLevel = Ref.create((Object)-1);
        BaseJSSymbolProcessor.MatchType matchType = this.isAcceptableQualifiedItem(element, (Ref<Integer>)matchLevel);
        if (WalkUpResolveProcessor.isCompleteOrWithContextMatchType(matchType) && 0 <= (Integer)matchLevel.get()) {
            if ((Integer)matchLevel.get() < this.myBestMatchedLevel) {
                this.matchData = null;
            }
            if (this.myBestMatchedLevel == -1 || (Integer)matchLevel.get() < this.myBestMatchedLevel) {
                this.myBestMatchedLevel = (Integer)matchLevel.get();
            }
        }
        if (WalkUpResolveProcessor.isCompleteOrWithContextMatchType(matchType)) {
            if (JSPsiImplUtils.isGetProperty((PsiElement)element) && this.myContext.getParent() instanceof JSDefinitionExpression) {
                matchType = BaseJSSymbolProcessor.MatchType.NOMATCH;
            }
            JSAttributeList.AccessType accessType = element.getAccessType();
            if (namespace != null && accessType != JSAttributeList.AccessType.PACKAGE_LOCAL && this.checkAndAddNotAccessibleJSElement(element, accessType)) {
                return;
            }
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL) {
            this.addPartialResult((PsiElement)element, null);
        } else if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT) {
            this.addResult(new JSResolveResult((PsiElement)element), EnumSet.of(JSTaggedResolveResult.ResolveResultTag.CONTEXT_MATCHES));
        } else if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
            this.addCompleteResult((PsiElement)element);
        }
    }

    private boolean checkAndAddNotAccessibleJSElement(@NotNull JSPsiElementBase element, @NotNull JSAttributeList.AccessType accessType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "checkAndAddNotAccessibleJSElement"));
        }
        if (accessType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessType", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "checkAndAddNotAccessibleJSElement"));
        }
        if (this.ecmal4 || this.typescript || !(this.myContext instanceof JSReferenceExpression) || JSResolveUtil.isSameReference((JSReferenceExpression)this.myContext, (PsiElement)element)) {
            return false;
        }
        PsiFile file1 = element.getContainingFile();
        PsiFile file2 = this.myContext.getContainingFile();
        if (file1 == null || file2 == null || JSVisibilityUtil.isAccessible(element.getNamespace(), (PsiElement)element, accessType, this.getContextScopeNames(), this.myContext, file1.isEquivalentTo((PsiElement)file2))) {
            return false;
        }
        this.addCompleteResultWithProblem((PsiElement)element, accessType == JSAttributeList.AccessType.PRIVATE ? "javascript.jsdoc.private.member.is.not.accessible.message" : (accessType == JSAttributeList.AccessType.PROTECTED ? "javascript.jsdoc.protected.member.is.not.accessible.message" : null));
        return true;
    }

    private void addCompleteResult(PsiElement element) {
        JSResolveResult o = new JSResolveResult(element, null, null);
        this.addCompleteResult(o);
    }

    private void addCompleteResult(ResolveResult o) {
        this.addResult(o, EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class));
    }

    private void addCompleteResultWithProblem(PsiElement element, String problemKey) {
        JSResolveResult o = new JSResolveResult(element, null, problemKey);
        this.addCompleteResult(o);
    }

    private void addPartialResult(PsiElement element, @Nullable String resolveProblem) {
        if (resolveProblem == null && this.myAddOnlyCompleteMatches) {
            resolveProblem = "*Undefined resolve problem!*";
        }
        JSResolveResult o = new JSResolveResult(element, null, resolveProblem);
        this.addResult(o, EnumSet.of(JSTaggedResolveResult.ResolveResultTag.PARTIAL));
    }

    private void addResult(ResolveResult o, @NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags) {
        boolean isDefinition;
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "addResult"));
        }
        PsiElement element = o.getElement();
        boolean bl = isDefinition = element instanceof JSDefinitionExpression && !WalkUpResolveProcessor.handleDefinitionWithHigherPriority((JSDefinitionExpression)element);
        if (this.mySkipDefs && isDefinition) {
            return;
        }
        if (this.matchData == null) {
            this.matchData = new ArrayList<JSTaggedResolveResult>(1);
        }
        if (this.isFromRelevantFileOrDirectory()) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.CURRENT_FILE);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance() || element instanceof JSDefinitionExpression && !((JSDefinitionExpression)element).isDeclaration() || element != null && WalkUpResolveProcessor.isTooBigForHighlighting(element.getContainingFile().getViewProvider().getVirtualFile()) || WalkUpResolveProcessor.isFromMinifiedFile(element)) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.MINOR_IMPORTANCE);
        }
        if (isDefinition) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.DEFINITION);
        }
        this.matchData.add(new JSTaggedResolveResult(o, tags));
    }

    public static boolean isTooBigForHighlighting(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "isTooBigForHighlighting"));
        }
        return !(file instanceof LightVirtualFile) && file.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    private static boolean isFromMinifiedFile(PsiElement element) {
        PsiFile file = element.getContainingFile();
        return file instanceof JSFile && ((JSFile)file).isMinified();
    }

    public PsiFile getBaseFile() {
        return this.myTargetFile;
    }

    private static boolean handleDefinitionWithHigherPriority(JSDefinitionExpression expr) {
        return expr.tryGetFunctionExpressionInitializer() != null;
    }

    @Override
    public String getRequiredName() {
        return this.myName;
    }

    public void allowPartialResults() {
        if (this.myAddOnlyCompleteMatchesSet) {
            return;
        }
        this.myAllowPartialResults = true;
        this.myCanHaveValidPartialMatches = true;
        this.setAddOnlyCompleteMatches(true);
    }

    public ResolveResult[] getResults() {
        List<JSTaggedResolveResult> taggedResolveResults = this.getTaggedResolveResults();
        return WalkUpResolveProcessor.convertResults(taggedResolveResults);
    }

    public static ResolveResult[] convertResults(@NotNull List<JSTaggedResolveResult> taggedResolveResults) {
        if (taggedResolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taggedResolveResults", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "convertResults"));
        }
        if (taggedResolveResults.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        int resultCount = taggedResolveResults.size();
        ResolveResult[] result = new ResolveResult[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            result[i] = taggedResolveResults.get((int)i).result;
        }
        return result;
    }

    @NotNull
    public List<JSTaggedResolveResult> getTaggedResolveResults() {
        if (this.matchData == null) {
            List<JSTaggedResolveResult> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "getTaggedResolveResults"));
            }
            return list;
        }
        Collections.sort(this.matchData);
        JSTaggedResolveResult topResult = this.matchData.get(0);
        boolean topResultIsPartial = topResult.tags.contains((Object)JSTaggedResolveResult.ResolveResultTag.PARTIAL);
        if (!this.myAllowPartialResults && topResultIsPartial) {
            this.matchData = null;
            List<JSTaggedResolveResult> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "getTaggedResolveResults"));
            }
            return list;
        }
        int resultCount = 0;
        for (JSTaggedResolveResult taggedResolveResult : this.matchData) {
            int compare;
            ResolveResult resolveResult = taggedResolveResult.result;
            if (!topResultIsPartial && (compare = taggedResolveResult.comparePriorityTo(topResult)) != 0) {
                assert (compare > 0);
                break;
            }
            if (topResultIsPartial && this.myCanHaveValidPartialMatches && resolveResult instanceof JSResolveResult && !ArrayUtil.contains((String)((JSResolveResult)resolveResult).getResolveProblemKey(), (String[])JSResolveResult.INSUFFICIENT_VISIBILITY_PROBLEM_KEYS)) {
                ((JSResolveResult)resolveResult).setValid(true);
            }
            ++resultCount;
        }
        List<JSTaggedResolveResult> list = this.matchData = this.matchData.subList(0, resultCount);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "getTaggedResolveResults"));
        }
        return list;
    }

    public void addLocalResults(@NotNull SinkResolveProcessor<ResolveResultSink> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "addLocalResults"));
        }
        ResolveResultSink sink = processor.getResultSink();
        List<Pair<ResolveResult, Boolean>> results = sink.getFilteredResults();
        for (Pair<ResolveResult, Boolean> pair : results) {
            ResolveResult e = (ResolveResult)pair.first;
            if (e.isValidResult() || !((Boolean)pair.second).booleanValue()) {
                EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
                PsiElement element = e.getElement();
                if (element != null && Boolean.TRUE.equals(element.getUserData(QualifiedItemProcessor.RECORD_TYPE_PROPERTY_KEY))) {
                    tags.add(JSTaggedResolveResult.ResolveResultTag.RECORD_TYPE_PROPERTY);
                }
                if (!((Boolean)pair.second).booleanValue()) {
                    tags.add(JSTaggedResolveResult.ResolveResultTag.MINOR_IMPORTANCE);
                }
                this.addResult(e, tags);
                continue;
            }
            if (!(e instanceof JSResolveResult)) continue;
            this.addPartialResult(e.getElement(), ((JSResolveResult)e).getResolveProblemKey());
        }
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "execute"));
        }
        if (!(element instanceof JSNamedElement) || Comparing.equal((String)((JSNamedElement)element).getName(), (String)this.myName, (boolean)true)) {
            this.addCompleteResult(element);
        }
        return true;
    }

    public void setSkipDefinitions(boolean b) {
        this.mySkipDefs = b;
    }

    public boolean isQualifierReferencesModule() {
        return this.myQualifierReferencesModule;
    }

    private boolean processObjectLiteral(@NotNull JSObjectLiteralExpression objectLiteral) {
        JSAttributeList.AccessType accessType;
        if (objectLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectLiteral", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor", "processObjectLiteral"));
        }
        JSProperty property = objectLiteral.findProperty(this.myName);
        if (property != null && !this.checkAndAddNotAccessibleJSElement((JSPsiElementBase)property, accessType = property.getAccessType())) {
            this.addResult(new JSResolveResult((PsiElement)property), EnumSet.of(JSTaggedResolveResult.ResolveResultTag.CONTEXT_MATCHES));
        }
        return true;
    }

    private class JSResolveTypeProcessor
    extends JSTypeProcessorBase {
        private final PsiElement myTarget;

        public JSResolveTypeProcessor(PsiElement target) {
            this.myTarget = target;
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
            JSContext staticOrInstance;
            String typeString;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveTypeProcessor", "process"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveTypeProcessor", "process"));
            }
            if (context.ensureProcessed(type, context)) {
                return;
            }
            if (!JSTypeUtils.processExpandedType(this, type, context, source)) {
                return;
            }
            if (WalkUpResolveProcessor.this.isStrictTypingPossible(source, type)) {
                WalkUpResolveProcessor.this.setAddOnlyCompleteMatches(true);
            }
            JSTypeSource typeSource = type.getSource();
            if (type instanceof JSRecordType) {
                PsiElement sourceElement = typeSource.getSourceElement();
                if (sourceElement instanceof JSDocComment) {
                    sourceElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)sourceElement);
                }
                if (sourceElement instanceof JSQualifiedNamedElement) {
                    JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSQualifiedNamedElement)sourceElement));
                    WalkUpResolveProcessor.this.myTypeInfo.addType(new JSNamespaceImpl(qName, JSContext.STATIC, false), true);
                }
                WalkUpResolveProcessor.this.myTypeInfo.addBaseObjectType();
            }
            if ((typeString = JSTypeUtils.getQualifiedNameMatchingType(type, true)) == null) {
                return;
            }
            WalkUpResolveProcessor.this.myNewPropertiesDefinitionAllowed |= JSTypeUtils.isNewPropertiesDefinitionAllowed(type);
            if (type instanceof JSAnyType || type instanceof JSGenericParameterImpl) {
                return;
            }
            JSContext jSContext = staticOrInstance = type instanceof JSNamedType ? ((JSNamedType)type).isStaticOrInstance() : JSContext.UNKNOWN;
            if (typeSource.isTypeScript()) {
                if (typeSource.isExplicitlyDeclared()) {
                    WalkUpResolveProcessor.this.setAddOnlyCompleteMatches(true);
                } else {
                    WalkUpResolveProcessor.this.allowPartialResults();
                }
            }
            WalkUpResolveProcessor.this.addTypeHierarchy(typeString, staticOrInstance, typeSource.isExplicitlyDeclared(), context.getJSModule());
            WalkUpResolveProcessor.this.tryAddFunctionType(type, source);
        }

        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveTypeProcessor", "processResolvedElement"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveTypeProcessor", "processResolvedElement"));
            }
            super.processResolvedElement(element, evaluateContext);
            if (element instanceof PsiFile && !CommonJSUtil.hasReexportedModules((PsiFile)element)) {
                WalkUpResolveProcessor.this.myQualifierReferencesModule = true;
                WalkUpResolveProcessor.this.myCheckFileLevelAccess = false;
                WalkUpResolveProcessor.this.setAddOnlyCompleteMatches(true);
            }
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveTypeProcessor", "setUnknownElement"));
            }
        }

        @Override
        public PsiElement getTarget() {
            return this.myTarget;
        }
    }

    private class ActionScriptResolveTypeProcessor
    extends JSTypeProcessorBase {
        private ActionScriptResolveTypeProcessor() {
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$ActionScriptResolveTypeProcessor", "process"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$ActionScriptResolveTypeProcessor", "process"));
            }
            if (context.ensureProcessed(type, context)) {
                return;
            }
            String typeString = type.getTypeText();
            if (type instanceof JSAnyType) {
                return;
            }
            final Ref proxyDescendant = new Ref();
            JSTypeEvaluateManager.iterateTypeHierarchy(typeString, new JSHierarchyProcessor(){

                @Override
                public boolean processNamespace(String qName, VirtualFile file) {
                    if ("Proxy".equals(qName)) {
                        proxyDescendant.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean processClass(JSClass clazz) {
                    if ("flash.utils.Proxy".equals(clazz.getQualifiedName())) {
                        proxyDescendant.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                    return true;
                }
            }, WalkUpResolveProcessor.this.myContext);
            if (proxyDescendant.get() != null) {
                return;
            }
            WalkUpResolveProcessor.this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(typeString);
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$ActionScriptResolveTypeProcessor", "setUnknownElement"));
            }
        }

        @Override
        public PsiElement getTarget() {
            return null;
        }
    }
}

