/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.IndexedFileTypeProvider;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaScriptResolveScopeProvider
extends JSElementResolveScopeProvider {
    private static final Set<FileType> myExpandedScopeFileTypes;

    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider", "getResolveScope"));
        }
        if (!this.isApplicable(file)) {
            return null;
        }
        return this.getProjectAndLibrariesScope(file, project);
    }

    public GlobalSearchScope getProjectAndLibrariesScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider", "getProjectAndLibrariesScope"));
        }
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file);
        if (module == null) {
            return this.getProjectScopeIncludingPredefines(project);
        }
        GlobalSearchScope scopeExcludingJsLibs = (GlobalSearchScope)((CachedValue)JSResolveUtil.ourScopeCache.get((UserDataHolder)module, null)).getValue();
        GlobalSearchScope libraryFilesScope = JSLibraryMappings.getInstance(project).getLibraryScopeForFile(file);
        return scopeExcludingJsLibs.uniteWith(libraryFilesScope);
    }

    @Override
    @NotNull
    public GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider", "getElementResolveScope"));
        }
        Project project = element.getProject();
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && (virtualFile = psiFile.getOriginalFile().getVirtualFile()) != null) {
            GlobalSearchScope globalSearchScope = this.isApplicable(virtualFile) ? ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(virtualFile) : this.getProjectAndLibrariesScope(virtualFile, project);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider", "getElementResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.getProjectScopeIncludingPredefines(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider", "getElementResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    public boolean isApplicable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider", "isApplicable"));
        }
        return myExpandedScopeFileTypes.contains(file.getFileType());
    }

    static {
        IndexedFileTypeProvider[] extensions;
        THashSet expandedScopeFileTypes = new THashSet(4);
        expandedScopeFileTypes.add(JavaScriptSupportLoader.JAVASCRIPT);
        expandedScopeFileTypes.add(ES6FileType.INSTANCE);
        expandedScopeFileTypes.add(FlowJSFileType.INSTANCE);
        expandedScopeFileTypes.add(HtmlFileType.INSTANCE);
        expandedScopeFileTypes.add(JSXHarmonyFileType.INSTANCE);
        for (IndexedFileTypeProvider iftp : extensions = (IndexedFileTypeProvider[])Extensions.getExtensions(IndexedFileTypeProvider.EP_NAME)) {
            Collections.addAll(expandedScopeFileTypes, iftp.getFileTypesToIndex());
        }
        myExpandedScopeFileTypes = expandedScopeFileTypes;
    }
}

