/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTagContextBuilder {
    private static final String BINDOWS_TYPE_PREFIX = "Bi";
    @Nullable
    public final PsiElement element;
    @Nullable
    public final String typeName;

    public JSTagContextBuilder(@NotNull PsiElement psiElement, @Nullable String defaultName) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/psi/resolve/JSTagContextBuilder", "<init>"));
        }
        String typeName = null;
        JSClass element = null;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
        if (tag != null) {
            PsiFile containingFile = tag.getContainingFile();
            typeName = JSTagContextBuilder.isBindowsXml(containingFile) ? JSTagContextBuilder.getTypeName(tag) : ((element = JSResolveUtil.getClassFromTagNameInMxml((PsiElement)tag)) != null ? element.getQualifiedName() : null);
        }
        this.typeName = typeName == null ? defaultName : typeName;
        this.element = element;
    }

    public static String getTypeName(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/psi/resolve/JSTagContextBuilder", "getTypeName"));
        }
        return BINDOWS_TYPE_PREFIX + tag.getLocalName();
    }

    public static boolean isBindowsXml(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/lang/javascript/psi/resolve/JSTagContextBuilder", "isBindowsXml"));
        }
        return containingFile.getName().endsWith(".xml") && containingFile instanceof XmlFile;
    }
}

