/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;

public class JSPropertyNameResolver
implements JSResolveUtil.Resolver<JSPropertyNameReference> {
    private final JSPropertyNameReference myProperty;

    public JSPropertyNameResolver(JSPropertyNameReference property) {
        this.myProperty = property;
    }

    @Override
    public ResolveResult[] doResolve() {
        JSProperty property = this.myProperty.getElement();
        JSType type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSObjectLiteralExpression)property.getParent()));
        String name = property.getName();
        if (name != null && type != null) {
            QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.TYPESCRIPT).createQualifiedItemProcessor((PsiElement)property, name);
            processor.process(type, new JSEvaluateContext(property.getContainingFile()), (PsiElement)property);
            ResolveResult[] results = processor.getResultsAsResolveResults();
            if (results.length > 0) {
                return results;
            }
        }
        return new ResolveResult[]{new JSResolveResult((PsiElement)property)};
    }
}

