/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.webcore.ScriptingLibraryProperties;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JSOrderEnumerationHandler
extends OrderEnumerationHandler {
    public boolean addCustomRootsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<String> urls) {
        if (forOrderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forOrderEntry", "com/intellij/lang/javascript/psi/resolve/JSOrderEnumerationHandler", "addCustomRootsForLibrary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSOrderEnumerationHandler", "addCustomRootsForLibrary"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/lang/javascript/psi/resolve/JSOrderEnumerationHandler", "addCustomRootsForLibrary"));
        }
        if (!(forOrderEntry instanceof LibraryOrderEntry)) {
            return false;
        }
        LibraryEx library = (LibraryEx)((LibraryOrderEntry)forOrderEntry).getLibrary();
        if (library == null || !(library.getProperties() instanceof ScriptingLibraryProperties)) {
            return false;
        }
        Collection sourceFilesUrls = ((ScriptingLibraryProperties)library.getProperties()).getSourceFilesUrls();
        if (sourceFilesUrls == null || sourceFilesUrls.isEmpty()) {
            return false;
        }
        urls.addAll(sourceFilesUrls);
        return true;
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        public boolean isApplicable(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/psi/resolve/JSOrderEnumerationHandler$FactoryImpl", "isApplicable"));
            }
            return WebModuleTypeBase.isWebModule((Module)module);
        }

        public OrderEnumerationHandler createHandler(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/psi/resolve/JSOrderEnumerationHandler$FactoryImpl", "createHandler"));
            }
            return new JSOrderEnumerationHandler();
        }
    }
}

