/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSContextLevel {
    @NotNull
    public final JSNamespace myNamespace;
    public final int myRelativeLevel;
    @Nullable
    public final PsiFile myJSModule;

    public JSContextLevel(@NotNull JSNamespace namespace, int relativeLevel) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSContextLevel", "<init>"));
        }
        this(namespace, relativeLevel, null);
    }

    public JSContextLevel(@NotNull JSNamespace namespace, int relativeLevel, @Nullable PsiFile jsModule) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSContextLevel", "<init>"));
        }
        this.myNamespace = namespace;
        this.myRelativeLevel = relativeLevel;
        this.myJSModule = jsModule;
    }

    public String toString() {
        return this.myNamespace.toString() + " ," + String.valueOf(this.myRelativeLevel);
    }

    @NotNull
    public GlobalSearchScope adjustScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSContextLevel", "adjustScope"));
        }
        GlobalSearchScope globalSearchScope = this.myJSModule != null ? GlobalSearchScope.fileScope((PsiFile)this.myJSModule) : scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSContextLevel", "adjustScope"));
        }
        return globalSearchScope;
    }
}

