/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JSCollectMembersToImplementProcessor
extends ResolveProcessor {
    private final String myName;
    private final boolean myAllMethods;

    public JSCollectMembersToImplementProcessor(String name, PsiElement context, boolean allMethods) {
        super(null, context);
        this.myName = name;
        this.myAllMethods = allMethods;
        this.setToSkipClassDeclarationsOnce(true);
        this.setToProcessHierarchy(true);
        this.setToProcessMembers(false);
        this.setTypeContext(true);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor", "execute"));
        }
        if (!(element instanceof JSClass)) {
            return true;
        }
        ResultSink sink = this.createResultSink();
        if (sink == null) {
            return false;
        }
        SinkResolveProcessor<ResultSink> processor = this.createProcessor(sink);
        List implicitlyImplemented = element instanceof JSClassBase ? ((JSClassBase)element).getImplicitlyDeclaredInterfaces() : Collections.emptyList();
        for (JSClass implementedInterface : ((JSClass)element).getImplementedInterfaces()) {
            boolean b;
            if (!JSClassUtils.isAllowImplementation(implementedInterface, this.place) || implicitlyImplemented.contains(implementedInterface) || (b = implementedInterface.processDeclarations(processor, ResolveState.initial(), (PsiElement)implementedInterface, (PsiElement)implementedInterface))) continue;
            this.process(processor);
            if (!this.myAllMethods) break;
        }
        if (this.myName == null && processor.getResults() != null) {
            this.process(processor);
        }
        return false;
    }

    @NotNull
    private SinkResolveProcessor<ResultSink> createProcessor(ResultSink sink) {
        SinkResolveProcessor<ResultSink> sinkResolveProcessor = new SinkResolveProcessor<ResultSink>(sink){
            {
                this.setToProcessHierarchy(true);
                this.setSkipImplicitDeclarations(true);
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor$1", "execute"));
                }
                if (element instanceof JSFunction) {
                    JSClass containingClass = JSUtils.getMemberContainingClass(element);
                    if (containingClass != null && "Object".equals(containingClass.getQualifiedName()) || ((JSFunction)element).isConstructor()) {
                        return true;
                    }
                } else if (element instanceof TypeScriptPropertySignature) {
                    if (this.place instanceof JSFunction) {
                        JSTypeDeclaration type = ((TypeScriptPropertySignature)element).getTypeDeclaration();
                        JSFunction.FunctionKind kind = ((JSFunction)this.place).getKind();
                        if (kind != JSFunction.FunctionKind.GETTER && kind != JSFunction.FunctionKind.SETTER) {
                            return !(type instanceof JSFunction) || super.execute((PsiElement)type, state);
                        }
                    }
                } else {
                    return true;
                }
                return super.execute(element, state);
            }
        };
        if (sinkResolveProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor", "createProcessor"));
        }
        return sinkResolveProcessor;
    }

    protected abstract boolean process(SinkResolveProcessor<?> var1);

    protected ResultSink createResultSink() {
        return this.myName != null ? new ResolveResultSink(this.place, this.myName) : null;
    }
}

