/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStub;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import icons.JavaScriptPsiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionImpl<StubT extends JSFunctionStub<?>>
extends JSFunctionBaseImpl<StubT>
implements JSSuppressionHolder {
    public static final Icon CONSTRUCTOR_ICON = JavaScriptPsiIcons.Members.Constructor;

    public JSFunctionImpl(ASTNode node) {
        super(node);
    }

    public JSFunctionImpl(StubT stub, IStubElementType type) {
        super(stub, type);
    }

    @Nullable
    public static JSType getReturnTypeInContext(@NotNull JSFunction function, @Nullable PsiElement place) {
        String name;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/impl/JSFunctionImpl", "getReturnTypeInContext"));
        }
        JSType type = JSFunctionImpl.evaluateReturnTypeFromHierarchy((JSFunctionItem)function);
        if (type instanceof JSAnyType && ("pop".equals(name = function.getName()) || "shift".equals(name))) {
            JSResolveUtil.GenericSignature signature;
            String qualifiedExpressionType;
            JSExpression instance;
            JSType classType;
            PsiElement element = JSResolveUtil.findParent((PsiElement)function);
            JSType jSType = classType = !(element instanceof JSClass) ? null : JSNamedType.createType(((JSClass)element).getQualifiedName(), JSTypeSource.EMPTY, JSContext.INSTANCE);
            if (classType != null && JSTypeUtils.isActionScriptVectorType(classType) && place instanceof JSReferenceExpression && (instance = ((JSReferenceExpression)place).getQualifier()) != null && (qualifiedExpressionType = JSResolveUtil.getQualifiedExpressionType(instance, place.getContainingFile())) != null && (signature = JSResolveUtil.extractGenericSignature(qualifiedExpressionType)) != null) {
                return JSTypeUtils.createType(signature.genericType, JSTypeSourceFactory.createTypeSource(place));
            }
        } else if (JSGenericTypeImpl.isGenericActionScriptVectorType(type) && place instanceof JSExpression) {
            JSExpression expression;
            JSExpression processedExpression = expression = (JSExpression)place;
            if (place instanceof JSReferenceExpression) {
                processedExpression = ((JSReferenceExpression)place).getQualifier();
            }
            if (processedExpression != null && processedExpression != expression) {
                String expressionType;
                JSExpression expressionToCheckType = processedExpression;
                PsiElement parent = processedExpression.getParent();
                if (parent instanceof JSCallExpression) {
                    expressionToCheckType = (JSExpression)parent;
                }
                if ((expressionType = JSResolveUtil.getQualifiedExpressionType(expressionToCheckType, expression.getContainingFile())) != null && (expressionType.equals("Vector") || expressionType.startsWith("Vector.<"))) {
                    return JSTypeUtils.createType(expressionType, JSTypeSourceFactory.createTypeSource(place));
                }
            }
        }
        return type;
    }

    @Nullable
    public static JSType evaluateReturnTypeFromHierarchy(@NotNull JSFunctionItem function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/impl/JSFunctionImpl", "evaluateReturnTypeFromHierarchy"));
        }
        JSType type = function.getReturnType();
        if (type != null && type.getSource().isExplicitlyDeclared()) {
            return type;
        }
        if (function.isOverride()) {
            Ref overridden = Ref.create(null);
            JSInheritanceUtil.processNearestOverriddenMethods(function, (Processor<JSFunction>)((Processor)function1 -> {
                overridden.set(function1);
                return function1 == null || function1.getReturnType() == null;
            }));
            if (!overridden.isNull()) {
                return ((JSFunction)overridden.get()).getReturnType();
            }
        }
        return type;
    }

    @Override
    public boolean constructorCanBeInvokedWithoutNew() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getStub();
        if (stub != null) {
            return stub.constructorCanBeInvokedWithoutNew();
        }
        return super.constructorCanBeInvokedWithoutNew();
    }

    @Override
    public boolean isConstructor() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)this);
        if (parent instanceof JSClass) {
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)this);
            if (dialect != null && dialect.isECMA6) {
                return Comparing.equal((String)"constructor", (String)this.getName(), (boolean)true);
            }
            return Comparing.equal((String)((JSClass)parent).getName(), (String)ActionScriptResolveUtil.replaceInternalName(this.getName()), (boolean)true);
        }
        return super.isConstructor();
    }

    @Override
    public boolean isOverride() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getStub();
        if (stub != null) {
            return stub.isOverride();
        }
        return super.isOverride();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSFunctionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSFunctionDeclaration((JSFunction)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public Icon getIcon(int flags) {
        return JSFunctionImpl.getFunctionIcon((JSFunctionItem)this, flags);
    }

    public static Icon getFunctionIcon(JSFunctionItem function, int flags) {
        PsiElement parent = JSResolveUtil.findParent((PsiElement)function);
        if (parent instanceof JSClass || parent instanceof JSPackageStatement) {
            JSAttributeList attributeList;
            JSAttributeList jSAttributeList = attributeList = function instanceof JSAttributeListOwner ? ((JSAttributeListOwner)function).getAttributeList() : null;
            if (attributeList != null && function instanceof JSFunction) {
                Icon initialIcon;
                JSFunction.FunctionKind kind = ((JSFunction)function).getKind();
                boolean isStatic = attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                switch (kind) {
                    case GETTER: {
                        initialIcon = isStatic ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
                        break;
                    }
                    case SETTER: {
                        initialIcon = isStatic ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
                        break;
                    }
                    case CONSTRUCTOR: {
                        initialIcon = CONSTRUCTOR_ICON;
                        break;
                    }
                    case SIMPLE: {
                        initialIcon = PlatformIcons.METHOD_ICON;
                        break;
                    }
                    default: {
                        assert (false) : "unexpected kind: " + kind;
                        initialIcon = PlatformIcons.METHOD_ICON;
                    }
                }
                Icon baseIcon = JSFunctionImpl.blendModifierFlags(initialIcon, attributeList, kind == JSFunction.FunctionKind.SIMPLE);
                return JSFunctionImpl.iconWithVisibilityIfNeeded((int)flags, (Icon)baseIcon, (Icon)attributeList.getAccessType().getIcon());
            }
        }
        return JSFunctionImpl.getIcon((JSPsiElementBase)function, JSFunctionImpl.getFunctionBaseIcon(function), flags);
    }

    @NotNull
    public static Icon getFunctionBaseIcon(@NotNull JSFunctionItem function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/impl/JSFunctionImpl", "getFunctionBaseIcon"));
        }
        boolean isFunction = function.getNamespace() == null && function.isNamespaceExplicitlyDeclared();
        Icon icon = isFunction ? PlatformIcons.FUNCTION_ICON : PlatformIcons.METHOD_ICON;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFunctionImpl", "getFunctionBaseIcon"));
        }
        return icon;
    }

    @Override
    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSFunctionStub stub = (JSFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)this);
        if (docComment instanceof JSDocComment && ((JSDocComment)docComment).isNamespaceExplicitlyDeclared()) {
            return ((JSDocComment)docComment).getNamespace();
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)this);
        if (parent instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof JSClass && !DialectDetector.isActionScript(parent)) {
            return JSPsiImplUtils.getNamespace((JSNamedElement)this);
        }
        return null;
    }

    @NotNull
    public SearchScope getUseScope() {
        if (this.isConstructor()) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFunctionImpl", "getUseScope"));
            }
            return searchScope;
        }
        SearchScope searchScope = JSResolveUtil.findUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFunctionImpl", "getUseScope"));
        }
        return searchScope;
    }

    public PsiElement getNavigationElement() {
        PsiElement parentOriginalElement;
        PsiElement parent = this.getParent();
        if (parent instanceof JSClass && (parentOriginalElement = parent.getNavigationElement()) != parent) {
            JSFunction functionByNameAndKind = ((JSClass)parentOriginalElement).findFunctionByNameAndKind(this.getName(), this.getKind());
            return functionByNameAndKind != null ? functionByNameAndKind : (this.isActionScriptDecompiledConstructor() ? parentOriginalElement : this);
        }
        return JSPsiImplUtils.findTopLevelNavigatableElement(this);
    }

    private boolean isActionScriptDecompiledConstructor() {
        if (!this.isConstructor() || !DialectDetector.isActionScript((PsiElement)this)) {
            return false;
        }
        JSAttributeList attributeList = this.getAttributeList();
        if (attributeList == null || !attributeList.hasExplicitModifier(JSAttributeList.ModifierType.NATIVE)) {
            return false;
        }
        JSParameterList parameterList = this.getParameterList();
        if (parameterList == null || parameterList.getParameters().length != 0) {
            return false;
        }
        return "*".equals(this.getReturnTypeString());
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof JSVariable) {
            String name = ((JSVariable)another).getName();
            if (Comparing.equal((String)this.getName(), (String)name) && ActionScriptResolveUtil.fieldIsImplicitAccessorMethod(this, (JSVariable)another)) {
                return true;
            }
        }
        return super.isEquivalentTo(another);
    }

    @Override
    public boolean isGenerator() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this);
        return holder != null && holder.hasFeature(JSLanguageFeature.YIELD_GENERATORS) && super.isGenerator();
    }
}

