/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSForStatementImpl
extends JSStatementImpl
implements JSForStatement {
    public JSForStatementImpl(ASTNode node) {
        super(node);
    }

    public JSVarStatement getVarDeclaration() {
        ASTNode node = this.getNode().findChildByType((IElementType)JSElementTypes.VAR_STATEMENT);
        return (JSVarStatement)(node != null ? node.getPsi() : null);
    }

    public JSExpression getInitialization() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.SEMICOLON) {
                return null;
            }
            if (!JSElementTypes.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public JSExpression getCondition() {
        int semicolonCount = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.SEMICOLON) {
                if (++semicolonCount != 2) continue;
                return null;
            }
            if (semicolonCount != 1 || !JSElementTypes.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public JSExpression getUpdate() {
        int semicolonCount = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.SEMICOLON) {
                ++semicolonCount;
                continue;
            }
            if (semicolonCount != 2 || !JSElementTypes.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public JSStatement getBody() {
        boolean passedRParen = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.RPAR) {
                passedRParen = true;
                continue;
            }
            if (!passedRParen || !JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(child.getElementType())) continue;
            return (JSStatement)child.getPsi();
        }
        return null;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSForStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSForStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSForStatementImpl", "processDeclarations"));
        }
        if (lastParent != null) {
            JSVarStatement statement = this.getVarDeclaration();
            if (statement != null) {
                return statement.processDeclarations(processor, state, lastParent, place);
            }
            JSExpression initialization = this.getInitialization();
            if (initialization != null) {
                return initialization.processDeclarations(processor, state, null, place);
            }
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSForStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSForStatement((JSForStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

