/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.StubElement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFileBaseImpl
extends PsiFileBase
implements JSFile {
    @Nullable
    private JSFileCachedData myCachedData;

    protected JSFileBaseImpl(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl", "<init>"));
        }
        super(viewProvider, language);
    }

    @NotNull
    public JSFileCachedData getCachedData() {
        JSFileCachedData cachedData = this.myCachedData;
        if (cachedData == null) {
            StubElement stub = this.getStub();
            if (stub != null) {
                if (stub instanceof JSFileStubImpl) {
                    cachedData = ((JSFileStubImpl)stub).getCachedData();
                } else {
                    Logger.getInstance(JSFileBaseImpl.class).error("stub: " + stub.getStubType() + "; file: " + this.getElementTypeForStubBuilder());
                }
            }
            if (cachedData == null) {
                cachedData = this.createCachedDataFromPsi();
            }
            this.myCachedData = cachedData;
        }
        JSFileCachedData jSFileCachedData = cachedData;
        if (jSFileCachedData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl", "getCachedData"));
        }
        return jSFileCachedData;
    }

    @Nullable
    public JSFileCachedData tryGetCachedData() {
        return this.myCachedData;
    }

    @NotNull
    private JSFileCachedData createCachedDataFromPsi() {
        JSFileCachedData cachedData = new JSFileCachedData();
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.processFile((JSFile)this, cachedData);
        }
        final JSFileCachedDataEvaluator evaluator = JSDialectSpecificHandlersFactory.forLanguage(DialectDetector.languageOfElement((PsiElement)this)).newFileCachedDataEvaluator(cachedData);
        JSRecursiveWalkingElementVisitor recursiveVisitor = new JSRecursiveWalkingElementVisitor(){

            public void visitElement(PsiElement element) {
                evaluator.startElement(element);
                super.visitElement(element);
            }

            protected void elementFinished(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl$1", "elementFinished"));
                }
                evaluator.finishElement(element);
                super.elementFinished(element);
            }
        };
        this.acceptChildren((PsiElementVisitor)recursiveVisitor);
        JSFileCachedData jSFileCachedData = cachedData;
        if (jSFileCachedData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl", "createCachedDataFromPsi"));
        }
        return jSFileCachedData;
    }

    public boolean isMinified() {
        return JSMinifiedFileUtil.isFileContentMinified(this.getViewProvider().getVirtualFile());
    }

    public boolean isCommonJSModule() {
        return this.getCachedData().isCommonJSModule();
    }

    public boolean isTestFile() {
        return this.getTestFileType() != null;
    }

    @Nullable
    public JSTestFileType getTestFileType() {
        return this.getCachedData().getTestFileType();
    }

    public boolean hasES6Syntax() {
        return this.getCachedData().hasES6Syntax();
    }

    @NotNull
    public Set<String> getReferencedPaths() {
        Set<String> set = this.getCachedData().getReferencedPaths();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl", "getReferencedPaths"));
        }
        return set;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myCachedData = null;
    }

    @NotNull
    public Map<String, JSReferenceExpression> getExtensionSymbols() {
        Map<String, JSReferenceExpression> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl", "getExtensionSymbols"));
        }
        return map;
    }

    @Nullable
    public JSType getExportsInnerAlias() {
        return this.getCachedData().getExportsInnerAlias();
    }
}

