/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.impl.JSFunctionVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.Stack;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class JSElementIterator
implements Iterator<PsiElement> {
    private boolean reverse;
    private final int minTextOffset;
    private final int maxTextOffset;
    private Stack<PsiElement> elementStack;
    private PsiElement next;
    private boolean retrieveNext;

    public JSElementIterator(PsiElement element) {
        this(element, false, 0, Integer.MAX_VALUE);
    }

    public JSElementIterator(PsiElement element, boolean reverse) {
        this(element, reverse, 0, Integer.MAX_VALUE);
    }

    public JSElementIterator(PsiElement element, boolean reverse, int minTextOffset, int maxTextOffset) {
        this.reverse = reverse;
        this.minTextOffset = minTextOffset;
        this.maxTextOffset = maxTextOffset;
        this.retrieveNext = true;
        this.elementStack = new Stack();
        if (element instanceof XmlFile) {
            for (JSElement embeddedElement : JSFunctionVisitor.getEmbeddedJSElements((XmlFile)element)) {
                if (reverse) {
                    this.elementStack.add(0, (Object)embeddedElement);
                    continue;
                }
                this.elementStack.push((Object)embeddedElement);
            }
        } else if (element instanceof JSElement) {
            this.elementStack.push((Object)element);
        } else {
            throw new ClassCastException(element.getClass().getName());
        }
    }

    protected abstract boolean visitElement(PsiElement var1);

    private void findNext() {
        PsiElement element = null;
        boolean pass = false;
        if (!this.elementStack.empty()) {
            do {
                int elementTextOffset;
                int elementTextEndOffset;
                if ((elementTextEndOffset = (elementTextOffset = (element = (PsiElement)this.elementStack.pop()).getTextOffset()) + element.getTextLength()) < this.minTextOffset || elementTextOffset > this.maxTextOffset) continue;
                pass = this.visitElement(element);
                this.pushChildren(element.getChildren(), this.reverse ? elementTextOffset : elementTextEndOffset);
            } while (!pass && !this.elementStack.empty());
        }
        this.next = pass ? element : null;
        this.retrieveNext = false;
    }

    private void pushChildren(PsiElement[] children, int elementTextOffset) {
        int childTextOffset = elementTextOffset;
        if (this.reverse) {
            for (int index = 0; index < children.length && childTextOffset <= this.maxTextOffset; ++index) {
                PsiElement child = children[index];
                childTextOffset = child.getTextOffset();
                if (childTextOffset > this.maxTextOffset) continue;
                this.elementStack.push((Object)child);
            }
        } else {
            for (int index = children.length - 1; index >= 0 && childTextOffset >= this.minTextOffset; --index) {
                PsiElement child = children[index];
                childTextOffset = child.getTextOffset() + child.getTextLength();
                if (childTextOffset < this.minTextOffset) continue;
                this.elementStack.push((Object)child);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.retrieveNext) {
            this.findNext();
        }
        return this.next != null;
    }

    @Override
    public PsiElement next() {
        if (this.retrieveNext) {
            this.findNext();
        }
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.retrieveNext = true;
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

